/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.frames.modules.typedgraph;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.EdgeFrame;
import com.tinkerpop.frames.FrameInitializer;
import com.tinkerpop.frames.FramedGraph;
import com.tinkerpop.frames.VertexFrame;
import com.tinkerpop.frames.modules.TypeResolver;
import com.tinkerpop.frames.modules.typedgraph.TypeField;
import com.tinkerpop.frames.modules.typedgraph.TypeRegistry;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;

public class TypeManager
implements TypeResolver,
FrameInitializer {
    private TypeRegistry typeRegistry;

    public TypeManager(TypeRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    @Override
    public Class<?>[] resolveTypes(Vertex v, Class<?> defaultType) {
        return new Class[]{this.resolve((Element)v, defaultType), VertexFrame.class};
    }

    @Override
    public Class<?>[] resolveTypes(Edge e, Class<?> defaultType) {
        return new Class[]{this.resolve((Element)e, defaultType), EdgeFrame.class};
    }

    private Class<?> resolve(Element e, Class<?> defaultType) {
        Class<?> typeHoldingTypeField = this.typeRegistry.getTypeHoldingTypeField(defaultType);
        if (typeHoldingTypeField != null) {
            Class<?> type;
            String value = (String)e.getProperty(typeHoldingTypeField.getAnnotation(TypeField.class).value());
            Class<?> clazz = type = value == null ? null : this.typeRegistry.getType(typeHoldingTypeField, value);
            if (type != null) {
                return type;
            }
        }
        return defaultType;
    }

    @Override
    public void initElement(Class<?> kind, FramedGraph<?> framedGraph, Element element) {
        TypeValue typeValue;
        Class<?> typeHoldingTypeField = this.typeRegistry.getTypeHoldingTypeField(kind);
        if (typeHoldingTypeField != null && (typeValue = kind.getAnnotation(TypeValue.class)) != null) {
            element.setProperty(typeHoldingTypeField.getAnnotation(TypeField.class).value(), (Object)typeValue.value());
        }
    }
}

