/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.ext.beans.StringModel;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.traversal.AllTraversalStrategy;
import org.jboss.windup.graph.traversal.OnlyOnceTraversalStrategy;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.SharedLibsTraversalStrategy;
import org.jboss.windup.graph.traversal.TraversalStrategy;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.util.ExecutionStatistics;

public class GetProjectTraversalMethod
implements WindupFreeMarkerMethod {
    public static final String NAME = "getProjectTraversal";
    public static final String ONLY_ONCE = "only_once";
    public static final String ALL = "all";
    public static final String SHARED = "shared";

    @Override
    public String getMethodName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Gets a ProjectModelTraversal for the given ProjectModel. An optional parameter specifies the traversal strategy ('only_once', 'all' or 'shared').";
    }

    public Object exec(List arguments) throws TemplateModelException {
        OnlyOnceTraversalStrategy traversalStrategy;
        ExecutionStatistics.get().begin(NAME);
        if (arguments.size() < 1) {
            throw new TemplateModelException("Error, method expects at least one argument (" + ProjectModel.class.getSimpleName() + ")");
        }
        StringModel stringModelArg = (StringModel)arguments.get(0);
        ProjectModel projectModel = (ProjectModel)stringModelArg.getWrappedObject();
        String traversalStrategyString = ALL;
        if (arguments.size() > 1) {
            traversalStrategyString = ((SimpleScalar)arguments.get(1)).getAsString();
        }
        if (traversalStrategyString == null) {
            traversalStrategyString = ALL;
        }
        switch (traversalStrategyString) {
            case "only_once": {
                traversalStrategy = new OnlyOnceTraversalStrategy();
                break;
            }
            case "shared": {
                traversalStrategy = new SharedLibsTraversalStrategy();
                break;
            }
            default: {
                Logger.getLogger(GetProjectTraversalMethod.class.getName()).warning("Unknown strategy name: " + traversalStrategyString);
            }
            case "all": {
                traversalStrategy = new AllTraversalStrategy();
            }
        }
        ProjectModelTraversal traversal = new ProjectModelTraversal(projectModel, (TraversalStrategy)traversalStrategy);
        ExecutionStatistics.get().end(NAME);
        return traversal;
    }

    @Override
    public void setContext(GraphRewrite event) {
    }
}

