/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker.problemsummary;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.category.IssueCategoryModel;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemFileSummary;

public class ProblemSummary {
    private final Object id;
    private final IssueCategoryModel issueCategoryModel;
    private final String ruleID;
    private final String issueName;
    private int numberFound;
    private final int effortPerIncident;
    private final Map<String, Map<FileModel, ProblemFileSummary>> descriptionToFiles = new LinkedHashMap<String, Map<FileModel, ProblemFileSummary>>();
    private final List<Link> links = new ArrayList<Link>();

    public ProblemSummary(Object id, IssueCategoryModel issueCategoryModel, String ruleID, String issueName, int numberFound, int effortPerIncident) {
        this.id = id;
        this.issueCategoryModel = issueCategoryModel;
        this.ruleID = ruleID;
        this.issueName = issueName;
        this.numberFound = numberFound;
        this.effortPerIncident = effortPerIncident;
    }

    public Object getId() {
        return this.id;
    }

    public IssueCategoryModel getIssueCategoryModel() {
        return this.issueCategoryModel;
    }

    public String getRuleID() {
        return this.ruleID;
    }

    public String getIssueName() {
        return this.issueName;
    }

    public int getNumberFound() {
        return this.numberFound;
    }

    void setNumberFound(int numberFound) {
        this.numberFound = numberFound;
    }

    public int getEffortPerIncident() {
        return this.effortPerIncident;
    }

    public Iterable<String> getDescriptions() {
        return this.descriptionToFiles.keySet();
    }

    public Iterable<ProblemFileSummary> getFilesForDescription(String description) {
        return this.descriptionToFiles.get(description).values();
    }

    private Map<FileModel, ProblemFileSummary> addDescription(String description) {
        Map<FileModel, ProblemFileSummary> files = this.descriptionToFiles.get(description);
        if (files == null) {
            files = new LinkedHashMap<FileModel, ProblemFileSummary>();
            this.descriptionToFiles.put(description, files);
        }
        return files;
    }

    public void addLink(Link link) {
        this.links.add(link);
    }

    public void addLink(String label, String url) {
        this.links.add(Link.to(label, url));
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void addFile(String description, FileModel fileModel) {
        Map<FileModel, ProblemFileSummary> files = this.addDescription(description);
        if (files.containsKey(fileModel)) {
            files.get(fileModel).addOccurrence();
        } else {
            files.put(fileModel, new ProblemFileSummary(fileModel, 1));
        }
    }
}

