/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.model;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.reporting.model.ApplicationReportModel;

@TypeValue(value="ApplicationReportIndexModel")
public interface ApplicationReportIndexModel
extends WindupVertexFrame {
    public static final String APPLICATION_REPORT_INDEX_TO_PROJECT_MODEL = "appReportIndexToProjectModel";
    public static final String APPLICATION_REPORT_INDEX_TO_REPORT_MODEL = "appReportIndexToAppReportModel";

    @JavaHandler
    public List<ApplicationReportModel> getApplicationReportModelsSortedByPriority();

    @Adjacency(label="appReportIndexToAppReportModel", direction=Direction.OUT)
    public Iterable<ApplicationReportModel> getApplicationReportModels();

    @Adjacency(label="appReportIndexToAppReportModel", direction=Direction.OUT)
    public void addApplicationReportModel(ApplicationReportModel var1);

    @Adjacency(label="appReportIndexToProjectModel", direction=Direction.OUT)
    public Iterable<ProjectModel> getProjectModels();

    @Adjacency(label="appReportIndexToProjectModel", direction=Direction.OUT)
    public void addProjectModel(ProjectModel var1);

    public static abstract class Impl
    implements ApplicationReportIndexModel,
    JavaHandlerContext<Vertex> {
        @Override
        public List<ApplicationReportModel> getApplicationReportModelsSortedByPriority() {
            ArrayList<ApplicationReportModel> reports = new ArrayList<ApplicationReportModel>();
            for (ApplicationReportModel m : this.getApplicationReportModels()) {
                reports.add(m);
            }
            Collections.sort(reports, new Comparator<ApplicationReportModel>(){

                @Override
                public int compare(ApplicationReportModel o1, ApplicationReportModel o2) {
                    return o1.getReportPriority() - o2.getReportPriority();
                }
            });
            return reports;
        }
    }
}

