/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.simple.impl;

import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.container.simple.Producer;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.proxy.ClassLoaderInterceptor;
import org.jboss.forge.furnace.proxy.ForgeProxy;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.spi.ExportedInstance;

public class SimpleProducerExportedInstance<T>
implements ExportedInstance<T> {
    private final Addon addon;
    private final Class<T> type;
    private final Class<? extends Producer<T>> producer;
    private final boolean singleton;
    private T delegate;

    public SimpleProducerExportedInstance(Addon addon, Class<T> type, Class<? extends Producer<T>> producer, boolean singleton) {
        this.addon = addon;
        this.type = type;
        this.producer = producer;
        this.singleton = singleton;
    }

    public T get() {
        if (this.singleton) {
            if (this.delegate == null) {
                this.delegate = this.newInstance();
            }
            return this.delegate;
        }
        return this.newInstance();
    }

    private T newInstance() {
        try {
            Object delegate = this.producer.newInstance().get();
            delegate = Proxies.enhance((ClassLoader)this.addon.getClassLoader(), (Object)delegate, (ForgeProxy)new ClassLoaderInterceptor(this.addon.getClassLoader(), delegate));
            return (T)delegate;
        }
        catch (Exception e) {
            throw new ContainerException("Could not create instance of [" + this.type.getName() + "] through reflection.", (Throwable)e);
        }
    }

    public void release(T instance) {
    }

    public String toString() {
        return this.type.getName() + " from " + this.addon;
    }

    public Class<? extends T> getActualType() {
        return this.type;
    }

    public Addon getSourceAddon() {
        return this.addon;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addon == null ? 0 : this.addon.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleProducerExportedInstance other = (SimpleProducerExportedInstance)obj;
        if (this.addon == null ? other.addon != null : !this.addon.equals(other.addon)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

