/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.simple.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.container.simple.EventListener;
import org.jboss.forge.furnace.container.simple.Producer;
import org.jboss.forge.furnace.container.simple.Service;
import org.jboss.forge.furnace.container.simple.SingletonService;
import org.jboss.forge.furnace.container.simple.impl.SimpleExportedInstance;
import org.jboss.forge.furnace.container.simple.impl.SimpleProducerExportedInstance;
import org.jboss.forge.furnace.container.simple.impl.SimpleSingletonExportedInstance;
import org.jboss.forge.furnace.spi.ExportedInstance;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.ClassLoaders;

public class SimpleServiceRegistry
implements ServiceRegistry {
    private static final Logger log = Logger.getLogger(SimpleServiceRegistry.class.getName());
    private final Addon addon;
    private final Set<Class<?>> serviceTypes = new HashSet();
    private final Set<Class<?>> singletonServiceTypes = new HashSet();
    private final Map<String, ExportedInstance<?>> instancesCache = new ConcurrentHashMap();

    public SimpleServiceRegistry(Addon addon) {
        Object exportedInstance;
        Class<?> serviceType;
        Class<?> type;
        this.addon = addon;
        Iterator<Class<?>> iterator = SimpleServiceRegistry.locateServices(addon, Service.class, EventListener.class).iterator();
        while (iterator.hasNext()) {
            serviceType = type = iterator.next();
            if (Producer.class.isAssignableFrom(type)) {
                serviceType = SimpleServiceRegistry.extractProducesType(type);
                exportedInstance = new SimpleProducerExportedInstance(addon, serviceType, type, false);
            } else {
                exportedInstance = new SimpleExportedInstance(addon, type);
            }
            this.serviceTypes.add(serviceType);
            this.instancesCache.put(serviceType.getName(), (ExportedInstance<?>)exportedInstance);
        }
        iterator = SimpleServiceRegistry.locateServices(addon, SingletonService.class).iterator();
        while (iterator.hasNext()) {
            serviceType = type = iterator.next();
            if (Producer.class.isAssignableFrom(type)) {
                serviceType = SimpleServiceRegistry.extractProducesType(type);
                exportedInstance = new SimpleProducerExportedInstance(addon, serviceType, type, true);
            } else {
                exportedInstance = new SimpleSingletonExportedInstance(addon, type);
            }
            this.singletonServiceTypes.add(serviceType);
            this.instancesCache.put(serviceType.getName(), (ExportedInstance<?>)exportedInstance);
        }
    }

    static Class<?> extractProducesType(Class<?> service) {
        Type[] genericInterfaces;
        for (Type type : genericInterfaces = service.getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType) || ((ParameterizedType)type).getRawType() != Producer.class) continue;
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    public <T> Set<ExportedInstance<T>> getExportedInstances(String clazz) {
        try {
            return this.getExportedInstances(Class.forName(clazz, false, this.addon.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            return Collections.emptySet();
        }
    }

    public <T> Set<ExportedInstance<T>> getExportedInstances(Class<T> clazz) {
        HashSet<ExportedInstance<T>> result = new HashSet<ExportedInstance<T>>();
        for (Class<?> type : this.singletonServiceTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            result.add(this.instancesCache.get(type.getName()));
        }
        for (Class<?> type : this.serviceTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            result.add(this.instancesCache.get(type.getName()));
        }
        return result;
    }

    public <T> ExportedInstance<T> getExportedInstance(String clazz) {
        try {
            Class<?> type = Class.forName(clazz, false, this.addon.getClassLoader());
            return this.getExportedInstance(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public <T> ExportedInstance<T> getExportedInstance(Class<T> clazz) {
        Assert.notNull(clazz, (String)"Requested Class type may not be null");
        for (Class<?> type : this.singletonServiceTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return this.instancesCache.get(type.getName());
        }
        for (Class<?> type : this.serviceTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return this.instancesCache.get(type.getName());
        }
        return null;
    }

    public Set<Class<?>> getExportedTypes() {
        HashSet result = new HashSet();
        result.addAll(this.serviceTypes);
        result.addAll(this.singletonServiceTypes);
        return Collections.unmodifiableSet(result);
    }

    public <T> Set<Class<T>> getExportedTypes(Class<T> type) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (Class<?> serviceType : this.getExportedTypes()) {
            if (!type.isAssignableFrom(serviceType)) continue;
            result.add(serviceType);
        }
        return result;
    }

    public boolean hasService(Class<?> clazz) {
        for (Class<?> service : this.getExportedTypes()) {
            if (!clazz.isAssignableFrom(service)) continue;
            return true;
        }
        return false;
    }

    public boolean hasService(String clazz) {
        try {
            return this.hasService(Class.forName(clazz, false, this.addon.getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void close() {
        this.serviceTypes.clear();
        this.singletonServiceTypes.clear();
        this.instancesCache.clear();
    }

    public String toString() {
        return "SimpleServiceRegistry [serviceTypes=" + this.serviceTypes + ", singletonServiceTypes=" + this.singletonServiceTypes + "]";
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<Class<?>> locateServices(Addon addon, Class<?> ... serviceTypes) {
        block26: {
            allServiceTypes = new HashSet<Class<?>>();
            try {
                block22: for (Class<?> serviceType : serviceTypes) {
                    resources = addon.getClassLoader().getResources("/META-INF/services/" + serviceType.getName());
lbl5:
                    // 10 sources

                    while (true) {
                        if (!resources.hasMoreElements()) continue block22;
                        resource = resources.nextElement();
                        stream = resource.openStream();
                        var10_11 = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(stream));
                            var12_15 = null;
                            while (true) {
                                ** try [egrp 2[TRYBLOCK] [2, 3 : 117->256)] { 
lbl15:
                                // 1 sources

                                break block26;
lbl16:
                                // 1 sources

                                catch (Throwable var13_18) {
                                    var12_15 = var13_18;
                                    throw var13_18;
                                }
                                break;
                            }
                        }
                        catch (Throwable var11_14) {
                            var10_11 = var11_14;
                            throw var11_14;
                        }
                        break;
                    }
                }
                return allServiceTypes;
            }
            catch (IOException ie) {
                SimpleServiceRegistry.log.log(Level.SEVERE, "Error while reading service classes", ie);
            }
            return allServiceTypes;
        }
        while (true) {
            if ((serviceName = reader.readLine()) == null) ** GOTO lbl5
            try {
                type = ClassLoaders.loadClass((ClassLoader)addon.getClassLoader(), (String)serviceName);
                if (!ClassLoaders.ownsClass((ClassLoader)addon.getClassLoader(), (Class)type)) ** continue;
                SimpleServiceRegistry.log.log(Level.FINE, "Service {0} registered", type);
                allServiceTypes.add(type);
            }
            catch (Throwable e) {
                SimpleServiceRegistry.log.log(Level.WARNING, "Service class not enabled due to underlying classloading error. This may happen if the class is not yet loaded by Furnace. If this is unexpected, enable DEBUG logging to see the full stack trace: " + SimpleServiceRegistry.getClassLoadingErrorMessage(addon, serviceName, e));
                SimpleServiceRegistry.log.log(Level.FINE, "Service " + serviceName + " not enabled due to underlying classloading error.", e);
            }
        }
lbl40:
        // 1 sources

        finally {
            block27: {
                if (reader == null) ** GOTO lbl5
                if (var12_15 == null) break block27;
                try {
                    reader.close();
                }
                catch (Throwable var13_17) {
                    var12_15.addSuppressed(var13_17);
                }
                ** GOTO lbl5
            }
            reader.close();
            ** GOTO lbl5
        }
        finally {
            block28: {
                if (stream == null) ** GOTO lbl5
                if (var10_11 == null) break block28;
                try {
                    stream.close();
                }
                catch (Throwable var11_13) {
                    var10_11.addSuppressed(var11_13);
                }
                ** GOTO lbl5
            }
            stream.close();
            ** continue;
        }
    }

    private static String getClassLoadingErrorMessage(Addon addon, String serviceType, Throwable e) {
        while (e.getCause() != null && e.getCause() != e) {
            e = e.getCause();
        }
        return e.getClass().getName() + ": " + e.getMessage();
    }
}

