/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.Error;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.ParameterList;
import com.strobel.reflection.Type;
import com.strobel.util.TypeUtils;
import java.util.Set;

public abstract class Binder {
    static boolean compareMethodSignatureAndName(MethodBase m1, MethodBase m2) {
        ParameterList p1 = m1.getParameters();
        ParameterList p2 = m2.getParameters();
        if (p1.size() != p2.size()) {
            return false;
        }
        int n = p1.size();
        for (int i = 0; i < n; ++i) {
            if (TypeUtils.areEquivalent(((ParameterInfo)p1.get(i)).getParameterType(), ((ParameterInfo)p2.get(i)).getParameterType())) continue;
            return false;
        }
        return true;
    }

    static int getHierarchyDepth(Type t) {
        int depth = 0;
        Type currentType = t;
        do {
            ++depth;
        } while ((currentType = currentType.getBaseType()) != null);
        return depth;
    }

    static MethodBase findMostDerivedNewSlotMethod(MethodBase[] match, int cMatches) {
        int deepestHierarchy = 0;
        MethodBase methodWithDeepestHierarchy = null;
        for (int i = 0; i < cMatches; ++i) {
            int currentHierarchyDepth = Binder.getHierarchyDepth(match[i].getDeclaringType());
            if (currentHierarchyDepth == deepestHierarchy) {
                throw Error.ambiguousMatch();
            }
            if (currentHierarchyDepth <= deepestHierarchy) continue;
            deepestHierarchy = currentHierarchyDepth;
            methodWithDeepestHierarchy = match[i];
        }
        return methodWithDeepestHierarchy;
    }

    public abstract MethodBase selectMethod(Set<BindingFlags> var1, MethodBase[] var2, Type[] var3);
}

