/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.reflection.MethodKey;
import com.strobel.reflection.RawMember;
import com.strobel.reflection.Type;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

final class RawMethod
extends RawMember {
    private final Method _method;
    private final int _hashCode;

    public RawMethod(Type context, Method method) {
        super(context);
        this._method = method;
        this._hashCode = this._method == null ? 0 : this._method.hashCode();
    }

    @Override
    public Method getRawMember() {
        return this._method;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isStrict() {
        return Modifier.isStrict(this.getModifiers());
    }

    public boolean isNative() {
        return Modifier.isNative(this.getModifiers());
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    public MethodKey createKey() {
        String name = this._method.getName();
        Class<?>[] argTypes = this._method.getParameterTypes();
        return new MethodKey(name, argTypes);
    }

    @Override
    public int hashCode() {
        return this._hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        RawMethod other = (RawMethod)o;
        return other._method == this._method;
    }
}

