/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class StructMember {
    protected int accessFlags;
    protected VBStyleCollection<StructGeneralAttribute, String> attributes;

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public VBStyleCollection<StructGeneralAttribute, String> getAttributes() {
        return this.attributes;
    }

    public boolean hasModifier(int modifier) {
        return (this.accessFlags & modifier) == modifier;
    }

    public boolean isSynthetic() {
        return this.hasModifier(4096) || this.attributes.containsKey("Synthetic");
    }

    protected VBStyleCollection<StructGeneralAttribute, String> readAttributes(DataInputFullStream in, ConstantPool pool) throws IOException {
        VBStyleCollection<StructGeneralAttribute, String> attributes = new VBStyleCollection<StructGeneralAttribute, String>();
        int length = in.readUnsignedShort();
        for (int i = 0; i < length; ++i) {
            int nameIndex = in.readUnsignedShort();
            String name = pool.getPrimitiveConstant(nameIndex).getString();
            StructGeneralAttribute attribute = this.readAttribute(in, pool, name);
            if (attribute == null) continue;
            if ("LocalVariableTable".equals(name) && attributes.containsKey(name)) {
                StructLocalVariableTableAttribute table = (StructLocalVariableTableAttribute)attributes.getWithKey(name);
                table.addLocalVariableTable((StructLocalVariableTableAttribute)attribute);
                continue;
            }
            attributes.addWithKey(attribute, attribute.getName());
        }
        return attributes;
    }

    protected StructGeneralAttribute readAttribute(DataInputFullStream in, ConstantPool pool, String name) throws IOException {
        StructGeneralAttribute attribute = StructGeneralAttribute.createAttribute(name);
        int length = in.readInt();
        if (attribute == null) {
            in.discard(length);
        } else {
            byte[] data = in.read(length);
            attribute.setInfo(data);
            attribute.initContent(pool);
        }
        return attribute;
    }
}

