/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.graph.traversal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.logging.Logger;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.traversal.ProjectModelTraversal;
import org.jboss.windup.graph.traversal.TraversalStrategy;

public class SharedLibsTraversalStrategy
implements TraversalStrategy {
    public static final Logger LOG = Logger.getLogger(SharedLibsTraversalStrategy.class.getName());

    public SharedLibsTraversalStrategy() {
        this.reset();
    }

    @Override
    public ProjectModelTraversal.TraversalState getTraversalState(ProjectModelTraversal traversal) {
        if ("<shared-libs>".equals(traversal.getCanonicalProject().getRootProjectModel().getUniqueID())) {
            return ProjectModelTraversal.TraversalState.ALL;
        }
        return ProjectModelTraversal.TraversalState.CHILDREN_ONLY;
    }

    @Override
    public void reset() {
    }

    @Override
    public Iterable<ProjectModelTraversal> getChildren(final ProjectModelTraversal traversal) {
        ProjectModel canonicalProject = traversal.getCanonicalProject();
        Iterable defaultChildren = Iterables.transform(canonicalProject.getChildProjects(), (Function)new Function<ProjectModel, ProjectModelTraversal>(){

            public ProjectModelTraversal apply(ProjectModel input) {
                return new ProjectModelTraversal(traversal, input, SharedLibsTraversalStrategy.this);
            }
        });
        return Iterables.filter((Iterable)defaultChildren, (Predicate)new Predicate<ProjectModelTraversal>(){

            public boolean apply(ProjectModelTraversal input) {
                ProjectModelTraversal.TraversalState traversalState = SharedLibsTraversalStrategy.this.getTraversalState(input);
                return traversalState != ProjectModelTraversal.TraversalState.NONE;
            }
        });
    }
}

