/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.identify;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Singleton;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.windup.rules.apps.java.archives.identify.ArchiveIdentificationService;

@Singleton
public class CompositeArchiveIdentificationService
implements ArchiveIdentificationService {
    private Set<ArchiveIdentificationService> identifiers = new LinkedHashSet<ArchiveIdentificationService>();

    public CompositeArchiveIdentificationService() {
    }

    public CompositeArchiveIdentificationService(ArchiveIdentificationService ... identifiers) {
        for (ArchiveIdentificationService identifier : identifiers) {
            this.addIdentifier(identifier);
        }
    }

    @Override
    public Coordinate getCoordinate(String checksum) {
        for (ArchiveIdentificationService identifier : this.identifiers) {
            Coordinate coordinate = identifier.getCoordinate(checksum);
            if (coordinate == null) continue;
            return coordinate;
        }
        return null;
    }

    public CompositeArchiveIdentificationService addIdentifier(ArchiveIdentificationService identifier) {
        this.identifiers.add(identifier);
        return this;
    }
}

