/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.BodyDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;

public class ModifierAccessor {
    public boolean hasModifier(ASTNode body, Modifier.ModifierKeyword modifier) {
        boolean result = false;
        List<Modifier> modifiers = this.getModifiers(body);
        for (Modifier m : modifiers) {
            if (m.getKeyword() != modifier) continue;
            result = true;
        }
        return result;
    }

    private List<Modifier> getModifiers(ASTNode body) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        List<Modifier> modifiers = this.getInternalModifiers(body);
        for (Modifier m : modifiers) {
            if (!(m instanceof Modifier)) continue;
            Modifier mod = m;
            result.add(mod);
        }
        return result;
    }

    public List<Modifier> clearVisibility(ASTNode body) {
        List<Modifier> modifiers = this.getModifiers(body);
        ArrayList<Modifier> toBeRemoved = new ArrayList<Modifier>();
        for (Modifier modifier : modifiers) {
            if (!modifier.isPrivate() && !modifier.isProtected() && !modifier.isPublic()) continue;
            toBeRemoved.add(modifier);
        }
        this.getInternalModifiers(body).removeAll(toBeRemoved);
        return modifiers;
    }

    public void addModifier(ASTNode body, Modifier.ModifierKeyword keyword) {
        if (!this.hasModifier(body, keyword)) {
            this.getInternalModifiers(body).add(body.getAST().newModifier(keyword));
        }
    }

    public void removeModifier(ASTNode body, Modifier.ModifierKeyword keyword) {
        List<Modifier> modifiers = this.getModifiers(body);
        ArrayList<Modifier> toBeRemoved = new ArrayList<Modifier>();
        for (Modifier modifier : modifiers) {
            if (!modifier.getKeyword().equals(keyword)) continue;
            toBeRemoved.add(modifier);
        }
        this.getInternalModifiers(body).removeAll(toBeRemoved);
    }

    private List<Modifier> getInternalModifiers(ASTNode body) {
        if (body instanceof BodyDeclaration) {
            return ((BodyDeclaration)body).modifiers();
        }
        return Collections.emptyList();
    }
}

