/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryStateStrategyImpl;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryStorageStrategyImpl;
import org.jboss.forge.furnace.impl.addons.CompositeDirtyChecker;
import org.jboss.forge.furnace.impl.addons.DirtyCheckableRepository;
import org.jboss.forge.furnace.impl.addons.DirtyChecker;
import org.jboss.forge.furnace.impl.addons.MutableAddonRepositoryStateStrategy;
import org.jboss.forge.furnace.impl.addons.MutableAddonRepositoryStorageStrategy;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;

public final class AddonRepositoryImpl
implements MutableAddonRepository,
DirtyCheckableRepository {
    private static final String DEFAULT_ADDON_DIR = ".forge/addons";
    private final MutableAddonRepositoryStorageStrategy storageRepository;
    private final MutableAddonRepositoryStateStrategy stateRepository;
    private final File addonDir;

    public static MutableAddonRepository forDirectory(Furnace furnace, File dir) {
        return new AddonRepositoryImpl(furnace, dir);
    }

    public static MutableAddonRepository forDefaultDirectory(Furnace furnace) {
        return new AddonRepositoryImpl(furnace, new File(OperatingSystemUtils.getUserHomePath(), DEFAULT_ADDON_DIR));
    }

    public static Version getRuntimeAPIVersion() {
        String versionOverride = System.getProperty("furnace.version.override");
        if (versionOverride != null) {
            return SingleVersion.valueOf((String)versionOverride);
        }
        return Versions.getImplementationVersionFor(AddonRepository.class);
    }

    public static boolean hasRuntimeAPIVersion() {
        return AddonRepositoryImpl.getRuntimeAPIVersion() != null;
    }

    public static boolean isApiCompatible(Version runtimeVersion, AddonId entry) {
        Assert.notNull((Object)entry, (String)"Addon entry must not be null.");
        return Versions.isApiCompatible((Version)runtimeVersion, (Version)entry.getApiVersion());
    }

    private AddonRepositoryImpl(Furnace furnace, File addonDir) {
        this(new AddonRepositoryStorageStrategyImpl(furnace.getLockManager(), addonDir), new AddonRepositoryStateStrategyImpl(furnace, addonDir), addonDir);
    }

    public AddonRepositoryImpl(MutableAddonRepositoryStorageStrategy storageRepository, MutableAddonRepositoryStateStrategy stateRepository, File addonDir) {
        Assert.notNull((Object)addonDir, (String)"Addon directory must not be null.");
        this.storageRepository = storageRepository;
        this.stateRepository = stateRepository;
        this.addonDir = addonDir;
    }

    public String toString() {
        return this.addonDir.getAbsolutePath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addonDir == null ? 0 : this.addonDir.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonRepositoryImpl other = (AddonRepositoryImpl)obj;
        return !(this.addonDir == null ? other.addonDir != null : !this.addonDir.equals(other.addonDir));
    }

    public boolean disable(AddonId addon) {
        return this.stateRepository.disable(addon);
    }

    public boolean enable(AddonId addon) {
        return this.stateRepository.enable(addon);
    }

    public boolean isEnabled(AddonId addon) {
        return this.stateRepository.isEnabled(addon);
    }

    public List<AddonId> listAll() {
        return this.stateRepository.listAll();
    }

    public List<AddonId> listEnabled() {
        return this.stateRepository.listEnabled();
    }

    public List<AddonId> listEnabledCompatibleWithVersion(Version version) {
        return this.stateRepository.listEnabledCompatibleWithVersion(version);
    }

    public int getVersion() {
        return this.stateRepository.getVersion();
    }

    public boolean deploy(AddonId addon, Iterable<AddonDependencyEntry> dependencies, Iterable<File> resourceJars) {
        return this.storageRepository.deploy(addon, dependencies, resourceJars);
    }

    public boolean undeploy(AddonId addonEntry) {
        return this.storageRepository.undeploy(addonEntry);
    }

    public File getAddonBaseDir(AddonId addon) {
        return this.storageRepository.getAddonBaseDir(addon);
    }

    public Set<AddonDependencyEntry> getAddonDependencies(AddonId addon) {
        return this.storageRepository.getAddonDependencies(addon);
    }

    public File getAddonDescriptor(AddonId addon) {
        return this.storageRepository.getAddonDescriptor(addon);
    }

    public List<File> getAddonResources(AddonId addon) {
        return this.storageRepository.getAddonResources(addon);
    }

    public boolean isDeployed(AddonId addon) {
        return this.storageRepository.isDeployed(addon);
    }

    public File getRootDirectory() {
        return this.addonDir;
    }

    public Date getLastModified() {
        return new Date(this.addonDir.lastModified());
    }

    @Override
    public DirtyChecker createDirtyChecker() {
        return new CompositeDirtyChecker(this.storageRepository.createDirtyChecker(), this.stateRepository.createDirtyChecker());
    }
}

