/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.addons.AbstractFileSystemAddonRepository;
import org.jboss.forge.furnace.impl.addons.DirtyChecker;
import org.jboss.forge.furnace.impl.addons.FileSystemDirtyChecker;
import org.jboss.forge.furnace.impl.addons.MutableAddonRepositoryStorageStrategy;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.furnace.versions.VersionRange;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.parser.xml.XMLParserException;

public final class AddonRepositoryStorageStrategyImpl
extends AbstractFileSystemAddonRepository
implements MutableAddonRepositoryStorageStrategy {
    private static final String DEPLOY_AS_SYMLINK_SYSTEM_PROPERTY = "furnace.addon.deploy_as_symlink";
    private static final Logger logger = Logger.getLogger(AddonRepositoryStorageStrategyImpl.class.getName());
    private static final String ATTR_EXPORT = "export";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_OPTIONAL = "optional";
    private static final String ATTR_VERSION = "version";
    private static final String ADDON_DESCRIPTOR_FILENAME = "addon.xml";
    private static final String DEPENDENCY_TAG_NAME = "dependency";
    private static final String DEPENDENCIES_TAG_NAME = "dependencies";

    public AddonRepositoryStorageStrategyImpl(LockManager lock, File addonDir) {
        super(lock, addonDir);
    }

    @Override
    public boolean deploy(final AddonId addon, final Iterable<AddonDependencyEntry> dependencies, final Iterable<File> resources) {
        return (Boolean)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                File addonSlotDir = AddonRepositoryStorageStrategyImpl.this.getAddonBaseDir(addon);
                File descriptor = AddonRepositoryStorageStrategyImpl.this.getAddonDescriptor(addon);
                if (resources != null) {
                    for (File resource : resources) {
                        if (resource.isDirectory()) {
                            Object child = addon.getName() + resource.getParentFile().getParentFile().getName();
                            child = OperatingSystemUtils.getSafeFilename((String)child);
                            File target = new File(addonSlotDir, (String)child);
                            if (Boolean.getBoolean(AddonRepositoryStorageStrategyImpl.DEPLOY_AS_SYMLINK_SYSTEM_PROPERTY)) {
                                logger.fine("Creating symlink from " + resource + " to " + target);
                                Files.createSymbolicLink(target.toPath(), resource.toPath(), new FileAttribute[0]);
                                continue;
                            }
                            logger.fine("Copying " + resource + " to " + target);
                            org.jboss.forge.furnace.impl.util.Files.copyDirectory(resource, target);
                            continue;
                        }
                        if (Boolean.getBoolean(AddonRepositoryStorageStrategyImpl.DEPLOY_AS_SYMLINK_SYSTEM_PROPERTY)) {
                            logger.fine("Creating symlink from " + resource + " to " + addonSlotDir.toPath().resolve(resource.getName()));
                            Files.createSymbolicLink(addonSlotDir.toPath().resolve(resource.getName()), resource.toPath(), new FileAttribute[0]);
                            continue;
                        }
                        logger.fine("Copying " + resource + " to " + addonSlotDir);
                        org.jboss.forge.furnace.impl.util.Files.copyFileToDirectory(resource, addonSlotDir);
                    }
                }
                Node addonXml = AddonRepositoryStorageStrategyImpl.this.getXmlRoot(descriptor);
                Node dependenciesNode = addonXml.getOrCreate(AddonRepositoryStorageStrategyImpl.DEPENDENCIES_TAG_NAME);
                if (dependencies != null) {
                    for (AddonDependencyEntry dependency : dependencies) {
                        String name = dependency.getName();
                        Node dep = null;
                        for (Node node : dependenciesNode.get(AddonRepositoryStorageStrategyImpl.DEPENDENCY_TAG_NAME)) {
                            if (!name.equals(node.getAttribute(AddonRepositoryStorageStrategyImpl.ATTR_NAME))) continue;
                            dep = node;
                            break;
                        }
                        if (dep == null) {
                            dep = dependenciesNode.createChild(AddonRepositoryStorageStrategyImpl.DEPENDENCY_TAG_NAME);
                            dep.attribute(AddonRepositoryStorageStrategyImpl.ATTR_NAME, name);
                        }
                        dep.attribute(AddonRepositoryStorageStrategyImpl.ATTR_VERSION, (Object)dependency.getVersionRange());
                        dep.attribute(AddonRepositoryStorageStrategyImpl.ATTR_EXPORT, (Object)dependency.isExported());
                        dep.attribute(AddonRepositoryStorageStrategyImpl.ATTR_OPTIONAL, (Object)dependency.isOptional());
                    }
                }
                try (FileOutputStream fos = new FileOutputStream(descriptor);){
                    Streams.write((InputStream)XMLParser.toXMLInputStream((Node)addonXml), (OutputStream)fos);
                }
                return true;
            }
        });
    }

    @Override
    public File getAddonBaseDir(final AddonId found) {
        Assert.notNull((Object)found, (String)"Addon must be specified.");
        Assert.notNull((Object)found.getVersion(), (String)"Addon version must be specified.");
        Assert.notNull((Object)found.getName(), (String)"Addon name must be specified.");
        return (File)this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File addonDir = new File(AddonRepositoryStorageStrategyImpl.this.getRootDirectory(), OperatingSystemUtils.getSafeFilename((String)found.toCoordinates()));
                return addonDir;
            }
        });
    }

    @Override
    public Set<AddonDependencyEntry> getAddonDependencies(final AddonId addon) {
        return (Set)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Set<AddonDependencyEntry>>(){

            @Override
            public Set<AddonDependencyEntry> call() throws Exception {
                LinkedHashSet<AddonDependencyEntry> result = new LinkedHashSet<AddonDependencyEntry>();
                File descriptor = AddonRepositoryStorageStrategyImpl.this.getAddonDescriptor(addon);
                try {
                    Node installed = AddonRepositoryStorageStrategyImpl.this.getXmlRoot(descriptor);
                    List children = installed.get("dependencies/dependency");
                    for (Node child : children) {
                        if (child == null) continue;
                        result.add(AddonDependencyEntry.create((String)child.getAttribute(AddonRepositoryStorageStrategyImpl.ATTR_NAME), (VersionRange)Versions.parseMultipleVersionRange((String)child.getAttribute(AddonRepositoryStorageStrategyImpl.ATTR_VERSION)), (boolean)Boolean.valueOf(child.getAttribute(AddonRepositoryStorageStrategyImpl.ATTR_EXPORT)), (boolean)Boolean.valueOf(child.getAttribute(AddonRepositoryStorageStrategyImpl.ATTR_OPTIONAL))));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                return result;
            }
        });
    }

    @Override
    public File getAddonDescriptor(final AddonId addon) {
        return (File)this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                File descriptorFile = AddonRepositoryStorageStrategyImpl.this.getAddonDescriptorFile(addon);
                try {
                    if (!descriptorFile.exists()) {
                        descriptorFile.mkdirs();
                        descriptorFile.delete();
                        descriptorFile.createNewFile();
                        FileOutputStream stream = null;
                        try {
                            stream = new FileOutputStream(descriptorFile);
                            Streams.write((InputStream)XMLParser.toXMLInputStream((Node)XMLParser.parse((String)"<addon/>")), (OutputStream)stream);
                        }
                        catch (Throwable throwable) {
                            Streams.closeQuietly(stream);
                            throw throwable;
                        }
                        Streams.closeQuietly((Closeable)stream);
                    }
                    return descriptorFile;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error initializing addon descriptor file.", e);
                }
            }
        });
    }

    private File getAddonDescriptorFile(final AddonId addon) {
        return (File)this.lock.performLocked(LockMode.READ, (Callable)new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(AddonRepositoryStorageStrategyImpl.this.getAddonBaseDir(addon), AddonRepositoryStorageStrategyImpl.ADDON_DESCRIPTOR_FILENAME);
            }
        });
    }

    @Override
    public List<File> getAddonResources(final AddonId found) {
        return (List)this.lock.performLocked(LockMode.READ, (Callable)new Callable<List<File>>(){

            @Override
            public List<File> call() throws Exception {
                File dir = AddonRepositoryStorageStrategyImpl.this.getAddonBaseDir(found);
                if (dir.exists()) {
                    File[] files = dir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            return pathname.isDirectory() || pathname.getName().endsWith(".jar");
                        }
                    });
                    return Arrays.asList(files);
                }
                return Collections.emptyList();
            }
        });
    }

    @Override
    public boolean isDeployed(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.READ, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                File addonBaseDir = AddonRepositoryStorageStrategyImpl.this.getAddonBaseDir(addon);
                File addonDescriptorFile = AddonRepositoryStorageStrategyImpl.this.getAddonDescriptorFile(addon);
                return addonBaseDir.exists() && addonDescriptorFile.exists();
            }
        });
    }

    @Override
    public boolean undeploy(final AddonId addon) {
        return (Boolean)this.lock.performLocked(LockMode.WRITE, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                File dir = AddonRepositoryStorageStrategyImpl.this.getAddonBaseDir(addon);
                return org.jboss.forge.furnace.impl.util.Files.delete(dir, true);
            }
        });
    }

    private Node getXmlRoot(File registryFile) throws FileNotFoundException, InterruptedException {
        Node installed = null;
        while (installed == null) {
            try {
                installed = XMLParser.parse((File)registryFile);
            }
            catch (XMLParserException e) {
                logger.log(Level.WARNING, "Error occurred while parsing [" + registryFile + "]", e);
            }
        }
        return installed;
    }

    @Override
    public DirtyChecker createDirtyChecker() {
        return new FileSystemDirtyChecker(this.addonDir);
    }
}

