/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.model.stats;

import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.BackFilterPipe;
import com.tinkerpop.pipes.transform.OutPipe;
import com.tinkerpop.pipes.util.Pipeline;
import com.tinkerpop.pipes.util.StartPipe;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.frames.TypeAwareFramedGraphQuery;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.model.JarArchiveModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.javaee.model.DataSourceModel;
import org.jboss.windup.rules.apps.javaee.model.EjbEntityBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateEntityModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateMappingFileModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateSessionFactoryModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JPAEntityModel;
import org.jboss.windup.rules.apps.javaee.model.JPANamedQueryModel;
import org.jboss.windup.rules.apps.javaee.model.JPAPersistenceUnitModel;
import org.jboss.windup.rules.apps.javaee.model.JaxRSWebServiceModel;
import org.jboss.windup.rules.apps.javaee.model.JaxWSWebServiceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsConnectionFactoryModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationType;
import org.jboss.windup.rules.apps.javaee.model.RMIServiceModel;
import org.jboss.windup.rules.apps.javaee.model.stats.GeneralStatsItemModel;
import org.jboss.windup.rules.apps.javaee.model.stats.TechnologiesStatsModel;
import org.jboss.windup.util.Logging;

public class TechnologiesStatsService
extends GraphService<TechnologiesStatsModel> {
    private static final Logger LOG = Logging.get(TechnologiesStatsService.class);

    public TechnologiesStatsService(GraphContext context) {
        super(context, TechnologiesStatsModel.class);
    }

    public TechnologiesStatsModel computeStats() {
        TechnologiesStatsModel stats = (TechnologiesStatsModel)this.create();
        stats.setComputed(new Date());
        Map<String, Integer> suffixToCount = this.countFilesBySuffix();
        Map<String, Integer> fileTypeShares = TechnologiesStatsService.countFilesShareBySuffix(suffixToCount);
        stats.setStatsFilesByTypeJavaPercent(this.item(fileTypeShares.getOrDefault("class", 0) + fileTypeShares.getOrDefault("java", 0)));
        stats.setStatsFilesByTypeJsPercent(this.item(fileTypeShares.getOrDefault("js", 0)));
        stats.setStatsFilesByTypeHtmlPercent(this.item(fileTypeShares.getOrDefault("html", 0)));
        stats.setStatsFilesByTypeCssPercent(this.item(fileTypeShares.getOrDefault("css", 0)));
        stats.setStatsFilesByTypeXmlPercent(this.item(fileTypeShares.getOrDefault("xml", 0)));
        stats.setStatsFilesByTypeFmtPercent(this.item(fileTypeShares.getOrDefault("fmt", 0)));
        stats.setStatsServicesEjbStateless(this.item(this.countByType(EjbSessionBeanModel.class, "sessionType", (Serializable)((Object)"stateless"))));
        stats.setStatsServicesEjbStateful(this.item(this.countByType(EjbSessionBeanModel.class, "sessionType", (Serializable)((Object)"stateful"))));
        stats.setStatsServicesEjbMessageDriven(this.item(this.countByType(EjbMessageDrivenModel.class)));
        int count = this.countByType(EjbEntityBeanModel.class) + this.countByType(JPAEntityModel.class);
        stats.setStatsServicesJpaEntitites(this.item(count));
        stats.setStatsServicesJpaNamedQueries(this.item(this.countByType(JPANamedQueryModel.class)));
        stats.setStatsServicesJpaPersistenceUnits(this.item(this.countByType(JPAPersistenceUnitModel.class)));
        stats.setStatsServicesRmiServices(this.item(this.countByType(RMIServiceModel.class)));
        stats.setStatsServicesHibernateConfigurationFiles(this.item(this.countByType(HibernateConfigurationFileModel.class)));
        stats.setStatsServicesHibernateEntities(this.item(this.countByType(HibernateEntityModel.class)));
        stats.setStatsServicesHibernateMappingFiles(this.item(this.countByType(HibernateMappingFileModel.class)));
        stats.setStatsServicesHibernateSessionFactories(this.item(this.countByType(HibernateSessionFactoryModel.class)));
        stats.setStatsServerResourcesDbJdbcDatasources(this.item(this.countByType(DataSourceModel.class, (Map<String, Serializable>)new HashMap<String, Serializable>(){
            {
                this.put("isXA", false);
            }
        })));
        stats.setStatsServerResourcesDbXaJdbcDatasources(this.item(this.countByType(DataSourceModel.class, (Map<String, Serializable>)new HashMap<String, Serializable>(){
            {
                this.put("isXA", true);
            }
        })));
        stats.setStatsServicesHttpJaxRs(this.item(this.countByType(JaxRSWebServiceModel.class)));
        stats.setStatsServicesHttpJaxWs(this.item(this.countByType(JaxWSWebServiceModel.class)));
        stats.setStatsServerResourcesMsgJmsQueues(this.item(this.countByType(JmsDestinationModel.class, "destinationType", (Serializable)((Object)JmsDestinationType.QUEUE.name()))));
        stats.setStatsServerResourcesMsgJmsTopics(this.item(this.countByType(JmsDestinationModel.class, "destinationType", (Serializable)((Object)JmsDestinationType.TOPIC.name()))));
        stats.setStatsServerResourcesMsgJmsConnectionFactories(this.item(this.countByType(JmsConnectionFactoryModel.class)));
        stats.setStatsServerResourcesJndiTotalEntries(this.item(this.countByType(JNDIResourceModel.class)));
        stats.setStatsJavaClassesOriginal(this.item((int)this.countJavaClassesOriginal()));
        stats.setStatsJavaClassesTotal(this.item(this.countByType(JavaClassModel.class)));
        stats.setStatsJavaJarsOriginal(this.item(this.countByType(JarArchiveModel.class) - this.countByType(IdentifiedArchiveModel.class)));
        stats.setStatsJavaJarsTotal(this.item(this.countByType(JarArchiveModel.class)));
        this.commit();
        return stats;
    }

    private <T extends WindupVertexFrame> int countByType(Class<T> clazz) {
        return this.countByType(clazz, null);
    }

    private <T extends WindupVertexFrame> int countByType(Class<T> clazz, final String propName, final Serializable value) {
        return this.countByType(clazz, (Map<String, Serializable>)(propName == null ? null : new HashMap<String, Serializable>(){
            {
                this.put(propName, value);
            }
        }));
    }

    private <T extends WindupVertexFrame> int countByType(Class<T> clazz, Map<String, Serializable> props) {
        FramedGraphQuery query = this.getGraphContext().getQuery().type(clazz);
        if (props != null) {
            for (Map.Entry<String, Serializable> prop : props.entrySet()) {
                String propName = prop.getKey();
                Serializable value = prop.getValue();
                if (value == null) {
                    query = query.has(propName);
                    continue;
                }
                query = query.has(propName, (Object)value);
            }
        }
        long count = this.count(query.vertices());
        LOG.info("Counted: Frame class == " + clazz.getSimpleName() + " && " + (props == null ? "no" : Integer.valueOf(props.size())) + " props ==> " + count);
        return (int)count;
    }

    private Map<String, Integer> countFilesBySuffix() {
        HashMap<String, Integer> suffixToCount = new HashMap<String, Integer>();
        Iterable files = this.getGraphContext().getQuery().type(FileModel.class).hasNot("isDirectory", (Object)true).vertices(FileModel.class);
        files.forEach(file -> {
            String suffix = StringUtils.substringAfterLast((String)file.getFileName(), (String)".");
            if (suffix.isEmpty()) {
                return;
            }
            Integer val = (Integer)suffixToCount.get(suffix);
            if (val == null) {
                suffixToCount.put(suffix, 1);
            } else {
                suffixToCount.put(suffix, val + 1);
            }
        });
        return suffixToCount;
    }

    private static Map<String, Integer> countFilesShareBySuffix(Map<String, Integer> suffixToCount) {
        int sum = suffixToCount.entrySet().stream().mapToInt(e -> (Integer)e.getValue()).sum();
        Map<String, Integer> shares = suffixToCount.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Integer)e.getValue() * 100 / sum));
        return shares;
    }

    private GeneralStatsItemModel item(int i) {
        return ((GeneralStatsItemModel)this.getGraphContext().create(GeneralStatsItemModel.class)).setQuantity(i);
    }

    private GeneralStatsItemModel item(String key, String label, Class<? extends WindupVertexFrame> type, Map<String, String> props) {
        GeneralStatsItemModel item = ((GeneralStatsItemModel)this.getGraphContext().create(GeneralStatsItemModel.class)).setKey(key).setLabel(label);
        long qty = this.countGraphVertices(type, props);
        item.setQuantity((int)qty);
        return item;
    }

    private long countGraphVertices(Class<? extends WindupVertexFrame> clazz, Map<String, String> props) {
        if (clazz == null) {
            throw new IllegalArgumentException("Frame type must be set (was null).");
        }
        LOG.info("Counting: Frame class == " + clazz.getSimpleName() + " && " + CollectionUtils.size(props) + " props.");
        FramedGraphQuery query = this.getGraphContext().getQuery().type(clazz);
        if (props != null) {
            for (Map.Entry<String, String> e : props.entrySet()) {
                String key = e.getKey();
                if (key == null || key.isEmpty()) continue;
                if (e.getValue() == null) {
                    query = query.has(key);
                    continue;
                }
                query = query.has(key, (Object)e.getValue());
            }
        }
        long count = this.count(query.vertices());
        LOG.info(" ==> " + count);
        return count;
    }

    private long countJavaClassesOriginal() {
        Iterable startVertices = new TypeAwareFramedGraphQuery(this.getGraphContext().getFramed()).type(JavaClassModel.class).vertices();
        Pipeline pipeline = new Pipeline();
        pipeline.addPipe((Pipe)new StartPipe((Object)startVertices));
        OutPipe outPipe = new OutPipe(new String[]{"decompiledSource"});
        pipeline.addPipe((Pipe)new BackFilterPipe((Pipe)outPipe));
        return pipeline.count();
    }
}

