/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.weblogic;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.category.IssueCategoryRegistry;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.model.ThreadPoolModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.Context;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverEjbConfigurationXmlRuleProvider.class}, perform="Discover WebLogic EJB XML Files")
public class ResolveWebLogicEjbXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveWebLogicEjbXmlRuleProvider.class.getSimpleName());

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"weblogic-ejb-jar");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel weblogicEjbXml) {
        String jndiLocation;
        JNDIResourceModel resource;
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        GraphService threadPoolService = new GraphService(event.getGraphContext(), ThreadPoolModel.class);
        GraphService ejbSessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        GraphService mdbService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        ClassificationModel classif = classificationService.attachClassification(context, (FileModel)weblogicEjbXml, "WebLogic EJB XML", "WebLogic Enterprise Java Bean XML Descriptor.");
        classif.setEffort(3);
        IssueCategoryRegistry issueCategoryRegistry = IssueCategoryRegistry.instance((Context)event.getRewriteContext());
        classif.setIssueCategory(IssueCategoryRegistry.loadFromGraph((GraphContext)event.getGraphContext(), (String)"mandatory"));
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)weblogicEjbXml, "WebLogic EJB XML", TechnologyTagLevel.IMPORTANT);
        Document doc = xmlFileService.loadDocumentQuiet(context, weblogicEjbXml);
        vendorSpecificationService.associateAsVendorExtension((FileModel)weblogicEjbXml, "ejb-jar.xml");
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)weblogicEjbXml.getProjectModel());
        for (Element resourceRef : JOOX.$((Document)doc).find("resource-description").get()) {
            String jndiLocation2 = JOOX.$((Element)resourceRef).child("jndi-name").text();
            String resourceName = JOOX.$((Element)resourceRef).child("res-ref-name").text();
            if (!StringUtils.isNotBlank((CharSequence)jndiLocation2) || !StringUtils.isNotBlank((CharSequence)resourceName)) continue;
            resource = jndiResourceService.createUnique(applications, jndiLocation2);
            LOG.info("JNDI Name: " + jndiLocation2 + " to Resource: " + resourceName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejb-local-reference-description").get()) {
            String resourceName = JOOX.$((Element)resourceRef).child("ejb-ref-name").text();
            jndiLocation = JOOX.$((Element)resourceRef).child("jndi-name").text();
            if (!StringUtils.isNotBlank((CharSequence)jndiLocation) || !StringUtils.isNotBlank((CharSequence)resourceName)) continue;
            resource = jndiResourceService.createUnique(applications, jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceName);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("name", resourceName)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
            for (EjbSessionBeanModel ejb : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)resourceName)) {
                ejb.setGlobalJndiReference(resource);
            }
        }
        for (Element enterpriseBeanTag : JOOX.$((Document)doc).find("weblogic-enterprise-bean").get()) {
            String localJndiLocation = JOOX.$((Element)enterpriseBeanTag).child("local-jndi-name").text();
            jndiLocation = JOOX.$((Element)enterpriseBeanTag).child("jndi-name").text();
            String ejbName = JOOX.$((Element)enterpriseBeanTag).child("ejb-name").text();
            String sessionClustered = JOOX.$((Element)enterpriseBeanTag).find("stateless-bean-is-clusterable").text();
            if (StringUtils.isBlank((CharSequence)(sessionClustered = StringUtils.trim((String)sessionClustered)))) {
                sessionClustered = JOOX.$((Element)enterpriseBeanTag).find("home-is-clusterable").text();
                sessionClustered = StringUtils.trim((String)sessionClustered);
            }
            ThreadPoolModel threadPoolModel = null;
            Iterator<Object> iterator = JOOX.$((Element)enterpriseBeanTag).find("pool").get().iterator();
            if (iterator.hasNext()) {
                Element poolDescriptor = (Element)iterator.next();
                Iterator maxSize = JOOX.$((Element)poolDescriptor).child("max-beans-in-free-pool").text();
                String minSize = JOOX.$((Element)poolDescriptor).child("initial-beans-in-free-pool").text();
                threadPoolModel = (ThreadPoolModel)threadPoolService.create();
                threadPoolModel.setApplications(ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)weblogicEjbXml.getProjectModel()));
                threadPoolModel.setPoolName(ejbName + "-ThreadPool");
                if (StringUtils.isNotBlank(maxSize)) {
                    try {
                        threadPoolModel.setMaxPoolSize(Integer.parseInt(maxSize));
                    }
                    catch (Exception e) {
                        LOG.warning("Unable to parse max pool size: " + maxSize);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)minSize)) {
                    try {
                        threadPoolModel.setMinPoolSize(Integer.parseInt(minSize));
                    }
                    catch (Exception e) {
                        LOG.warning("Unable to parse min pool size: " + minSize);
                    }
                }
            }
            if (threadPoolModel != null) {
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    sessionBean.setThreadPool(threadPoolModel);
                }
                for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    mdb.setThreadPool(threadPoolModel);
                }
            }
            Map<String, Integer> txTimeouts = this.parseTxTimeout(enterpriseBeanTag, ejbName);
            if (StringUtils.isNotBlank((CharSequence)jndiLocation) && StringUtils.isNotBlank((CharSequence)ejbName)) {
                JNDIResourceModel jndiRef = jndiResourceService.createUnique(applications, jndiLocation);
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    LOG.info("Registering EJB: " + ejbName + " to JNDI: " + jndiLocation);
                    sessionBean.setGlobalJndiReference(jndiRef);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)localJndiLocation) && StringUtils.isNotBlank((CharSequence)ejbName)) {
                JNDIResourceModel localJndiRef = jndiResourceService.createUnique(applications, localJndiLocation);
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    LOG.info("Registering EJB: " + ejbName + " to JNDI: " + jndiLocation);
                    sessionBean.setLocalJndiReference(localJndiRef);
                }
            }
            if (txTimeouts.size() > 0 && StringUtils.isNotBlank((CharSequence)ejbName)) {
                for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    sessionBean.setTxTimeouts(txTimeouts);
                }
            }
            for (Element messageDrivenDescriptor : JOOX.$((Element)enterpriseBeanTag).find("message-driven-descriptor").get()) {
                for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                    String destination = JOOX.$((Element)messageDrivenDescriptor).child("destination-jndi-name").text();
                    if (StringUtils.isNotBlank((CharSequence)destination)) {
                        JmsDestinationModel jndiRef = jmsDestinationService.createUnique(applications, destination);
                        mdb.setDestination(jndiRef);
                    }
                    if (txTimeouts.size() <= 0) continue;
                    mdb.setTxTimeouts(txTimeouts);
                }
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)"true", (CharSequence)sessionClustered)) continue;
            for (EjbSessionBeanModel sessionBean : ejbSessionBeanService.findAllByProperty("ejbBeanName", (Object)ejbName)) {
                LOG.info("Setting bean as clustered: " + ejbName);
                sessionBean.setClustered(true);
            }
        }
    }

    private Map<String, Integer> parseTxTimeout(Element enterpriseBeanTag, String ejbName) {
        HashMap<String, Integer> transactionTimeouts = new HashMap<String, Integer>();
        String transactionTimeoutSeconds = JOOX.$((Element)enterpriseBeanTag).child("transaction-descriptor").child("trans-timeout-seconds").text();
        String methodName = "*";
        if (StringUtils.isNotBlank((CharSequence)transactionTimeoutSeconds)) {
            try {
                Integer txTimeout = Integer.parseInt(transactionTimeoutSeconds);
                transactionTimeouts.put(methodName, txTimeout);
            }
            catch (Exception e) {
                LOG.info("EJB: " + ejbName + " contains bad reference to TX Timeout on Method: " + methodName);
            }
        }
        return transactionTimeouts;
    }
}

