/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation.packagemapping;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.event.listener.GraphChangedListener;
import java.util.Map;
import java.util.logging.Logger;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.IgnoredFileModel;
import org.jboss.windup.graph.service.ArchiveService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.archives.model.IgnoredArchiveModel;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMapping;
import org.jboss.windup.util.Logging;

public class ArchivePackageNameIdentificationGraphChangedListener
implements GraphChangedListener {
    private static Logger LOG = Logging.get(ArchivePackageNameIdentificationGraphChangedListener.class);
    private GraphRewrite event;

    public ArchivePackageNameIdentificationGraphChangedListener(GraphRewrite event) {
        this.event = event;
    }

    public void vertexPropertyChanged(Vertex vertex, String key, Object oldValue, Object setValue) {
        try {
            if ("ArchiveModel:archiveName".equals(key)) {
                ArchiveService archiveService = new ArchiveService(this.event.getGraphContext());
                ArchiveModel archive = (ArchiveModel)archiveService.frame(vertex);
                if (archive instanceof IgnoredArchiveModel || archive instanceof IdentifiedArchiveModel) {
                    return;
                }
                boolean exclusivelyKnown = PackageNameMapping.isExclusivelyKnownArchive(this.event, archive.getFilePath());
                for (FileModel inputFile : WindupConfigurationService.getConfigurationModel((GraphContext)this.event.getGraphContext()).getInputPaths()) {
                    if (!inputFile.equals(archive)) continue;
                    exclusivelyKnown = false;
                }
                if (exclusivelyKnown) {
                    IgnoredFileModel ignoredFileModel = (IgnoredFileModel)new GraphService(this.event.getGraphContext(), IgnoredFileModel.class).addTypeToModel((WindupVertexFrame)archive);
                    ignoredFileModel.setIgnoredRegex("3rd Party Archive");
                    new GraphService(this.event.getGraphContext(), IdentifiedArchiveModel.class).addTypeToModel((WindupVertexFrame)archive);
                }
            }
        }
        catch (Throwable t) {
            LOG.warning("Failed to check package name mapping due to: " + t.getMessage());
        }
    }

    public void vertexPropertyRemoved(Vertex vertex, String key, Object removedValue) {
    }

    public void vertexAdded(Vertex vertex) {
    }

    public void vertexRemoved(Vertex vertex, Map<String, Object> props) {
    }

    public void edgeAdded(Edge edge) {
    }

    public void edgePropertyChanged(Edge edge, String key, Object oldValue, Object setValue) {
    }

    public void edgePropertyRemoved(Edge edge, String key, Object removedValue) {
    }

    public void edgeRemoved(Edge edge, Map<String, Object> props) {
    }
}

