/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.xml;

import java.nio.file.Path;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.metadata.TechnologyMetadata;
import org.jboss.windup.config.metadata.TechnologyReference;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.config.parser.metadata.MetadataTechnologyHandler;
import org.jboss.windup.rules.apps.java.JavaTechnologyMetadata;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="java-technology-metadata", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class JavaTechnologyMetadataHandler
implements ElementHandler<TechnologyMetadata> {
    public static final String ELEM_NAME = "java-technology-metadata";
    private static final String ADDITIONAL_CLASSPATH = "additional-classpath";

    public TechnologyMetadata processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        TechnologyReference technologyReference = new MetadataTechnologyHandler(){}.processElement(handlerManager, JOOX.$((Element)element).child("technology").get(0));
        JavaTechnologyMetadata javaTechnologyMetadata = new JavaTechnologyMetadata(technologyReference);
        List children = JOOX.$((Element)element).children(ADDITIONAL_CLASSPATH).get();
        for (Element child : children) {
            String additionalClasspath = child.getTextContent();
            additionalClasspath = FilenameUtils.separatorsToSystem((String)additionalClasspath);
            Path path = handlerManager.getXmlInputPath().getParent().resolve(additionalClasspath);
            javaTechnologyMetadata.addAdditionalClasspath(path);
        }
        return javaTechnologyMetadata;
    }
}

