/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.mavenize;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.Adjacency;
import com.tinkerpop.frames.modules.javahandler.JavaHandler;
import com.tinkerpop.frames.modules.javahandler.JavaHandlerContext;
import com.tinkerpop.frames.modules.typedgraph.TypeValue;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.forge.furnace.versions.ComparableVersion;
import org.jboss.windup.rules.apps.java.archives.model.ArchiveCoordinateModel;
import org.jboss.windup.rules.apps.mavenize.MavenizeRuleProvider;
import org.jboss.windup.rules.apps.mavenize.PomXmlModel;
import org.jboss.windup.util.Logging;

@TypeValue(value="GlobalBom-")
public interface GlobalBomModel
extends PomXmlModel {
    public static final String TYPE = "GlobalBom-";
    public static final String DEFINES = "GlobalBom-defines";

    @JavaHandler
    @Adjacency(label="GlobalBom-defines", direction=Direction.OUT)
    public void addNewerDependency(ArchiveCoordinateModel var1);

    public static abstract class Impl
    implements GlobalBomModel,
    JavaHandlerContext<Vertex> {
        private static final Logger LOG = Logging.get(MavenizeRuleProvider.class);

        @Override
        public void addNewerDependency(ArchiveCoordinateModel newCoord) {
            LOG.info("Adding: " + newCoord.toString());
            Vertex v = (Vertex)this.it();
            Iterable<ArchiveCoordinateModel> existingDeps = this.getDependencies();
            for (ArchiveCoordinateModel dep : existingDeps) {
                LOG.info("  ---- Dep: " + dep.toString());
                if (!StringUtils.equals((CharSequence)newCoord.getGroupId(), (CharSequence)dep.getGroupId()) || !StringUtils.equals((CharSequence)newCoord.getArtifactId(), (CharSequence)dep.getArtifactId()) || !StringUtils.equals((CharSequence)newCoord.getClassifier(), (CharSequence)dep.getClassifier()) || !StringUtils.equals((CharSequence)newCoord.getPackaging(), (CharSequence)dep.getPackaging())) continue;
                if (0 < Impl.compareVersions(newCoord.getVersion(), dep.getVersion())) {
                    dep.setVersion(newCoord.getVersion());
                }
                return;
            }
            this.addDependency(newCoord);
            LOG.info("Added: " + newCoord.toString());
        }

        private static int compareVersions(String aS, String bS) {
            ComparableVersion a = new ComparableVersion(aS);
            ComparableVersion b = new ComparableVersion(bS);
            return b.compareTo(a);
        }
    }
}

