/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.Arrays;
import java.util.List;
import org.ocpsoft.rewrite.config.CompositeOperation;
import org.ocpsoft.rewrite.config.NoOp;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;

public abstract class DefaultOperationBuilder
implements OperationBuilder {
    @Override
    public OperationBuilder and(Operation other) {
        if (other == null) {
            return this;
        }
        return new DefaultOperationBuilderInternal(this, other);
    }

    static class DefaultOperationBuilderInternal
    extends DefaultOperationBuilder
    implements CompositeOperation {
        private final Operation left;
        private final Operation right;

        public DefaultOperationBuilderInternal(Operation left, Operation right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public void perform(Rewrite event, EvaluationContext context) {
            this.left.perform(event, context);
            this.right.perform(event, context);
        }

        @Override
        public List<Operation> getOperations() {
            return Arrays.asList(this.left, this.right);
        }

        public String toString() {
            if (this.left instanceof NoOp) {
                return "" + this.right;
            }
            return this.left + ".and(" + this.right + ")";
        }
    }
}

