/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.jboss.forge.addon.environment.Environment;
import org.jboss.forge.addon.maven.environment.Network;
import org.jboss.forge.addon.maven.projects.FileResourceModelSource;
import org.jboss.forge.addon.maven.projects.PlexusContainer;
import org.jboss.forge.addon.maven.projects.util.RepositoryUtils;
import org.jboss.forge.addon.maven.resources.MavenModelResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.manager.maven.MavenContainer;
import org.jboss.forge.furnace.util.Assert;

public class MavenBuildManager {
    private Map<MavenModelResource, ProjectBuildingResult> cache = new WeakHashMap<MavenModelResource, ProjectBuildingResult>();
    private MavenContainer container = new MavenContainer();
    private Environment environment;
    private PlexusContainer plexus;
    private ProjectBuilder builder;

    ProjectBuildingResult getProjectBuildingResult(MavenModelResource pomResource) throws ProjectBuildingException {
        ProjectBuildingResult result = this.cache.get(pomResource);
        if (result == null) {
            try {
                boolean inTransaction;
                ProjectBuildingRequest request = this.getProjectBuildingRequest();
                Assert.notNull((Object)request, (String)"Project building request was null");
                request.setResolveDependencies(true);
                boolean bl = inTransaction = !((File)pomResource.getUnderlyingResourceObject()).exists();
                if (inTransaction) {
                    result = this.getBuilder().build((ModelSource)new FileResourceModelSource((FileResource<?>)pomResource), request);
                } else {
                    result = this.getBuilder().build((File)pomResource.getUnderlyingResourceObject(), request);
                    this.monitorResource(pomResource);
                }
            }
            catch (ProjectBuildingException pbe) {
                List results = pbe.getResults();
                if (results != null && results.size() > 0) {
                    result = (ProjectBuildingResult)results.get(0);
                }
                throw pbe;
            }
            finally {
                if (result != null) {
                    this.cache.put(pomResource, result);
                }
            }
        }
        return result;
    }

    private void monitorResource(MavenModelResource pomResource) {
        ResourceMonitor monitor = pomResource.monitor();
        monitor.addResourceListener(event -> {
            this.cache.remove(pomResource);
            monitor.cancel();
        });
    }

    ProjectBuildingRequest getProjectBuildingRequest() {
        return this.getProjectBuildingRequest(Network.isOffline((Environment)this.getEnvironment()));
    }

    ProjectBuildingRequest getProjectBuildingRequest(boolean offline) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Settings settings = this.container.getSettings();
            DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
            MavenExecutionRequestPopulator populator = this.getPlexus().lookup(MavenExecutionRequestPopulator.class);
            populator.populateFromSettings((MavenExecutionRequest)executionRequest, this.container.getSettings());
            populator.populateDefaults((MavenExecutionRequest)executionRequest);
            RepositorySystem system = this.getPlexus().lookup(RepositorySystem.class);
            ProjectBuildingRequest request = executionRequest.getProjectBuildingRequest();
            ArtifactRepository localRepository = RepositoryUtils.toArtifactRepository("local", new File(settings.getLocalRepository()).toURI().toURL().toString(), null, true, true);
            request.setLocalRepository(localRepository);
            ArrayList<ArtifactRepository> settingsRepos = new ArrayList<ArtifactRepository>(request.getRemoteRepositories());
            List activeProfiles = settings.getActiveProfiles();
            Map profiles = settings.getProfilesAsMap();
            for (String id : activeProfiles) {
                Profile profile = (Profile)profiles.get(id);
                if (profile == null) continue;
                List repositories = profile.getRepositories();
                for (Repository repository : repositories) {
                    settingsRepos.add(RepositoryUtils.convertFromMavenSettingsRepository(repository));
                }
            }
            request.setRemoteRepositories(settingsRepos);
            request.setSystemProperties(System.getProperties());
            DefaultRepositorySystemSession repositorySession = MavenRepositorySystemUtils.newSession();
            Proxy activeProxy = settings.getActiveProxy();
            if (activeProxy != null) {
                DefaultProxySelector dps = new DefaultProxySelector();
                dps.add(RepositoryUtils.convertFromMavenProxy(activeProxy), activeProxy.getNonProxyHosts());
                repositorySession.setProxySelector((ProxySelector)dps);
            }
            LocalRepository localRepo = new LocalRepository(settings.getLocalRepository());
            repositorySession.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)repositorySession, localRepo));
            repositorySession.setOffline(offline);
            List mirrors = executionRequest.getMirrors();
            if (mirrors != null) {
                DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
                for (Mirror mirror : mirrors) {
                    mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
                }
                repositorySession.setMirrorSelector((MirrorSelector)mirrorSelector);
            }
            request.setRepositorySession((RepositorySystemSession)repositorySession);
            request.setProcessPlugins(false);
            request.setResolveDependencies(false);
            ProjectBuildingRequest projectBuildingRequest = request;
            return projectBuildingRequest;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Maven project building request", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private ProjectBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = this.getPlexus().lookup(ProjectBuilder.class);
        }
        return this.builder;
    }

    File getLocalRepositoryDirectory() {
        return new File(this.container.getSettings().getLocalRepository()).getAbsoluteFile();
    }

    void evictFromCache(MavenModelResource pom) {
        this.cache.remove(pom);
    }

    private PlexusContainer getPlexus() {
        if (this.plexus == null) {
            this.plexus = (PlexusContainer)((Object)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), PlexusContainer.class).get());
        }
        return this.plexus;
    }

    private Environment getEnvironment() {
        if (this.environment == null) {
            this.environment = (Environment)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), Environment.class).get();
        }
        return this.environment;
    }
}

