/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.maven.projects.MavenBuildSystem;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenFacetImpl;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.maven.projects.MavenProject;
import org.jboss.forge.addon.maven.projects.facets.MavenDependencyFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenEnterpriseResourcesFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenJavaCompilerFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenJavaSourceFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenMetadataFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenPackagingFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenResourcesFacet;
import org.jboss.forge.addon.maven.projects.facets.MavenWebResourcesFacet;
import org.jboss.forge.addon.parser.java.facets.JavaCompilerFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.AbstractProjectProvider;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProvidedProjectFacet;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.facets.EnterpriseResourcesFacet;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;

public class MavenBuildSystemImpl
extends AbstractProjectProvider
implements MavenBuildSystem {
    private static final Logger log = Logger.getLogger(MavenBuildSystemImpl.class.getName());
    private Map<Class<? extends ProjectFacet>, Class<? extends ProjectFacet>> facets = new IdentityHashMap<Class<? extends ProjectFacet>, Class<? extends ProjectFacet>>();

    public String getType() {
        return "Maven";
    }

    public Project createProject(Resource<?> target) {
        MavenProject project = new MavenProject(target);
        FacetFactory factory = (FacetFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), FacetFactory.class).get();
        try {
            factory.install((Faceted)project, MavenFacetImpl.class);
            factory.install((Faceted)project, MavenPluginFacet.class);
            factory.install((Faceted)project, MavenMetadataFacet.class);
            factory.install((Faceted)project, MavenPackagingFacet.class);
            factory.install((Faceted)project, MavenDependencyFacet.class);
            try {
                factory.register((Faceted)project, MavenWebResourcesFacet.class);
            }
            catch (IllegalStateException e) {
                log.log(Level.FINE, "Could not install [" + MavenWebResourcesFacet.class.getName() + "] into project [" + (Object)((Object)project) + "]", e);
            }
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Could not install Maven into Project located at [" + target.getFullyQualifiedName() + "]", e);
        }
        return project;
    }

    public boolean containsProject(Resource<?> target) {
        if (target.exists()) {
            Resource pom = target.getChild("pom.xml");
            return pom != null && pom.exists();
        }
        return false;
    }

    public Set<Class<? extends ProvidedProjectFacet>> getProvidedFacetTypes() {
        HashSet<Class<PackagingFacet>> result = new HashSet<Class<PackagingFacet>>();
        result.add(MavenFacet.class);
        result.add(MavenPluginFacet.class);
        result.add(DependencyFacet.class);
        result.add(MetadataFacet.class);
        result.add(PackagingFacet.class);
        return Collections.unmodifiableSet(result);
    }

    public int priority() {
        return 0;
    }

    public Class<? extends ProjectFacet> resolveProjectFacet(Class<? extends ProjectFacet> facet) {
        if (this.facets.isEmpty()) {
            this.facets.put(DependencyFacet.class, MavenDependencyFacet.class);
            this.facets.put(JavaCompilerFacet.class, MavenJavaCompilerFacet.class);
            this.facets.put(JavaSourceFacet.class, MavenJavaSourceFacet.class);
            this.facets.put(MetadataFacet.class, MavenMetadataFacet.class);
            this.facets.put(PackagingFacet.class, MavenPackagingFacet.class);
            this.facets.put(ResourcesFacet.class, MavenResourcesFacet.class);
            this.facets.put(WebResourcesFacet.class, MavenWebResourcesFacet.class);
            this.facets.put(EnterpriseResourcesFacet.class, MavenEnterpriseResourcesFacet.class);
        }
        return this.facets.getOrDefault(facet, facet);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getType() == null ? 0 : this.getType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MavenBuildSystemImpl)) {
            return false;
        }
        MavenBuildSystemImpl other = (MavenBuildSystemImpl)((Object)obj);
        return !(this.getType() == null ? other.getType() != null : !this.getType().equals(other.getType()));
    }
}

