/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.maven.projects.archetype.ui;

import org.jboss.forge.addon.maven.projects.archetype.ui.AbstractArchetypeSelectionWizardStep;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;

public class ArchetypeSelectionWizardStep
extends AbstractArchetypeSelectionWizardStep {
    private UIInput<String> archetypeGroupId;
    private UIInput<String> archetypeArtifactId;
    private UIInput<String> archetypeVersion;
    private UIInput<String> archetypeRepository;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Maven: Choose Archetype").description("Enter a Maven archetype coordinate");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory inputFactory = builder.getInputComponentFactory();
        this.archetypeGroupId = (UIInput)((UIInput)inputFactory.createInput("archetypeGroupId", String.class).setLabel("Archetype Group Id")).setRequired(true);
        this.archetypeArtifactId = (UIInput)((UIInput)inputFactory.createInput("archetypeArtifactId", String.class).setLabel("Archetype Artifact Id")).setRequired(true);
        this.archetypeVersion = (UIInput)((UIInput)inputFactory.createInput("archetypeVersion", String.class).setLabel("Archetype Version")).setRequired(true);
        this.archetypeRepository = (UIInput)inputFactory.createInput("archetypeRepository", String.class).setLabel("Archetype repository URL");
        builder.add(this.archetypeGroupId).add(this.archetypeArtifactId).add(this.archetypeVersion).add(this.archetypeRepository);
    }

    public void validate(UIValidationContext validator) {
        String repository = this.getArchetypeRepository();
        if (!Strings.isNullOrEmpty((String)repository) && !Strings.isURL((String)repository)) {
            validator.addValidationError(this.archetypeRepository, "Archetype repository must be a valid URL");
        }
    }

    @Override
    protected String getArchetypeRepository() {
        return (String)this.archetypeRepository.getValue();
    }

    @Override
    protected String getArchetypeVersion() {
        return (String)this.archetypeVersion.getValue();
    }

    @Override
    protected String getArchetypeArtifactId() {
        return (String)this.archetypeArtifactId.getValue();
    }

    @Override
    protected String getArchetypeGroupId() {
        return (String)this.archetypeGroupId.getValue();
    }
}

