/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue;

import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.EntryList;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRangeQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeySliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KCVSUtil {
    private static final Logger log = LoggerFactory.getLogger(KeyColumnValueStore.class);
    private static final StaticBuffer START = BufferUtil.zeroBuffer(8);
    private static final StaticBuffer END = BufferUtil.oneBuffer(32);

    public static StaticBuffer get(KeyColumnValueStore store, StaticBuffer key, StaticBuffer column, StoreTransaction txh) throws BackendException {
        KeySliceQuery query = new KeySliceQuery(key, column, BufferUtil.nextBiggerBuffer(column)).setLimit(2);
        EntryList result = store.getSlice(query, txh);
        if (result.size() > 1) {
            log.warn("GET query returned more than 1 result: store {} | key {} | column {}", new Object[]{store.getName(), key, column});
        }
        if (result.isEmpty()) {
            return null;
        }
        return ((Entry)result.get(0)).getValueAs(StaticBuffer.STATIC_FACTORY);
    }

    public static KeyIterator getKeys(KeyColumnValueStore store, StoreFeatures features, int keyLength, int sliceLength, StoreTransaction txh) throws BackendException {
        SliceQuery slice = new SliceQuery(BufferUtil.zeroBuffer(sliceLength), BufferUtil.oneBuffer(sliceLength)).setLimit(1);
        if (features.hasUnorderedScan()) {
            return store.getKeys(slice, txh);
        }
        if (features.hasOrderedScan()) {
            return store.getKeys(new KeyRangeQuery(BufferUtil.zeroBuffer(keyLength), BufferUtil.oneBuffer(keyLength), slice), txh);
        }
        throw new UnsupportedOperationException("Scan not supported by this store");
    }

    public static boolean containsKeyColumn(KeyColumnValueStore store, StaticBuffer key, StaticBuffer column, StoreTransaction txh) throws BackendException {
        return KCVSUtil.get(store, key, column, txh) != null;
    }

    public static boolean containsKey(KeyColumnValueStore store, StaticBuffer key, StoreTransaction txh) throws BackendException {
        return KCVSUtil.containsKey(store, key, 32, txh);
    }

    public static boolean containsKey(KeyColumnValueStore store, StaticBuffer key, int maxColumnLength, StoreTransaction txh) throws BackendException {
        StaticBuffer start = START;
        StaticBuffer end = END;
        if (maxColumnLength > 32) {
            end = BufferUtil.oneBuffer(maxColumnLength);
        }
        return !store.getSlice(new KeySliceQuery(key, START, END).setLimit(1), txh).isEmpty();
    }

    public static boolean matches(SliceQuery query, StaticBuffer column) {
        return query.getSliceStart().compareTo(column) <= 0 && query.getSliceEnd().compareTo(column) > 0;
    }

    public static boolean matches(KeyRangeQuery query, StaticBuffer key, StaticBuffer column) {
        return KCVSUtil.matches(query, column) && query.getKeyStart().compareTo(key) <= 0 && query.getKeyEnd().compareTo(key) > 0;
    }

    public static Map<StaticBuffer, EntryList> emptyResults(List<StaticBuffer> keys) {
        HashMap<StaticBuffer, EntryList> result = new HashMap<StaticBuffer, EntryList>(keys.size());
        for (StaticBuffer key : keys) {
            result.put(key, EntryList.EMPTY_LIST);
        }
        return result;
    }
}

