/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.keyvalue.KeySelector;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;

public class KVQuery
extends BaseQuery {
    private final StaticBuffer start;
    private final StaticBuffer end;
    private final Predicate<StaticBuffer> keyFilter;

    public KVQuery(StaticBuffer start, StaticBuffer end) {
        this(start, end, Integer.MAX_VALUE);
    }

    public KVQuery(StaticBuffer start, StaticBuffer end, int limit) {
        this(start, end, (Predicate<StaticBuffer>)Predicates.alwaysTrue(), limit);
    }

    public KVQuery(StaticBuffer start, StaticBuffer end, Predicate<StaticBuffer> keyFilter, int limit) {
        super(limit);
        this.start = start;
        this.end = end;
        this.keyFilter = keyFilter;
    }

    public StaticBuffer getStart() {
        return this.start;
    }

    public StaticBuffer getEnd() {
        return this.end;
    }

    public KeySelector getKeySelector() {
        return new KeySelector(this.keyFilter, this.getLimit());
    }
}

