/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.example;

import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.io.File;

public class GraphOfTheGodsFactory {
    public static final String INDEX_NAME = "search";

    public static TitanGraph create(String directory) {
        TitanFactory.Builder config = TitanFactory.build();
        config.set("storage.backend", "berkeleyje");
        config.set("storage.directory", directory);
        config.set("index.search.backend", "elasticsearch");
        config.set("index.search.directory", directory + File.separator + "es");
        config.set("index.search.elasticsearch.local-mode", true);
        config.set("index.search.elasticsearch.client-only", false);
        TitanGraph graph = config.open();
        GraphOfTheGodsFactory.load(graph);
        return graph;
    }

    public static void load(TitanGraph graph) {
        TitanManagement mgmt = graph.getManagementSystem();
        PropertyKey name = mgmt.makePropertyKey("name").dataType(String.class).make();
        TitanGraphIndex namei = mgmt.buildIndex("name", Vertex.class).addKey(name).unique().buildCompositeIndex();
        mgmt.setConsistency(namei, ConsistencyModifier.LOCK);
        PropertyKey age = mgmt.makePropertyKey("age").dataType(Integer.class).make();
        mgmt.buildIndex("vertices", Vertex.class).addKey(age).buildMixedIndex(INDEX_NAME);
        PropertyKey time = mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey reason = mgmt.makePropertyKey("reason").dataType(String.class).make();
        PropertyKey place = mgmt.makePropertyKey("place").dataType(Geoshape.class).make();
        TitanGraphIndex eindex = mgmt.buildIndex("edges", Edge.class).addKey(reason).addKey(place).buildMixedIndex(INDEX_NAME);
        mgmt.makeEdgeLabel("father").multiplicity(Multiplicity.MANY2ONE).make();
        mgmt.makeEdgeLabel("mother").multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel battled = mgmt.makeEdgeLabel("battled").signature(time).make();
        mgmt.buildEdgeIndex(battled, "battlesByTime", Direction.BOTH, Order.DESC, time);
        mgmt.makeEdgeLabel("lives").signature(reason).make();
        mgmt.makeEdgeLabel("pet").make();
        mgmt.makeEdgeLabel("brother").make();
        mgmt.makeVertexLabel("titan").make();
        mgmt.makeVertexLabel("location").make();
        mgmt.makeVertexLabel("god").make();
        mgmt.makeVertexLabel("demigod").make();
        mgmt.makeVertexLabel("human").make();
        mgmt.makeVertexLabel("monster").make();
        mgmt.commit();
        TitanTransaction tx = graph.newTransaction();
        TitanVertex saturn = tx.addVertexWithLabel("titan");
        saturn.setProperty("name", "saturn");
        saturn.setProperty("age", 10000);
        TitanVertex sky = tx.addVertexWithLabel("location");
        ElementHelper.setProperties((Element)sky, (Object[])new Object[]{"name", "sky"});
        TitanVertex sea = tx.addVertexWithLabel("location");
        ElementHelper.setProperties((Element)sea, (Object[])new Object[]{"name", "sea"});
        TitanVertex jupiter = tx.addVertexWithLabel("god");
        ElementHelper.setProperties((Element)jupiter, (Object[])new Object[]{"name", "jupiter", "age", 5000});
        TitanVertex neptune = tx.addVertexWithLabel("god");
        ElementHelper.setProperties((Element)neptune, (Object[])new Object[]{"name", "neptune", "age", 4500});
        TitanVertex hercules = tx.addVertexWithLabel("demigod");
        ElementHelper.setProperties((Element)hercules, (Object[])new Object[]{"name", "hercules", "age", 30});
        TitanVertex alcmene = tx.addVertexWithLabel("human");
        ElementHelper.setProperties((Element)alcmene, (Object[])new Object[]{"name", "alcmene", "age", 45});
        TitanVertex pluto = tx.addVertexWithLabel("god");
        ElementHelper.setProperties((Element)pluto, (Object[])new Object[]{"name", "pluto", "age", 4000});
        TitanVertex nemean = tx.addVertexWithLabel("monster");
        ElementHelper.setProperties((Element)nemean, (Object[])new Object[]{"name", "nemean"});
        TitanVertex hydra = tx.addVertexWithLabel("monster");
        ElementHelper.setProperties((Element)hydra, (Object[])new Object[]{"name", "hydra"});
        TitanVertex cerberus = tx.addVertexWithLabel("monster");
        ElementHelper.setProperties((Element)cerberus, (Object[])new Object[]{"name", "cerberus"});
        TitanVertex tartarus = tx.addVertexWithLabel("location");
        ElementHelper.setProperties((Element)tartarus, (Object[])new Object[]{"name", "tartarus"});
        jupiter.addEdge("father", saturn);
        jupiter.addEdge("lives", sky).setProperty("reason", (Object)"loves fresh breezes");
        jupiter.addEdge("brother", neptune);
        jupiter.addEdge("brother", pluto);
        neptune.addEdge("lives", sea).setProperty("reason", (Object)"loves waves");
        neptune.addEdge("brother", jupiter);
        neptune.addEdge("brother", pluto);
        hercules.addEdge("father", jupiter);
        hercules.addEdge("mother", alcmene);
        ElementHelper.setProperties((Element)hercules.addEdge("battled", nemean), (Object[])new Object[]{"time", 1, "place", Geoshape.point(38.1f, 23.7f)});
        ElementHelper.setProperties((Element)hercules.addEdge("battled", hydra), (Object[])new Object[]{"time", 2, "place", Geoshape.point(37.7f, 23.9f)});
        ElementHelper.setProperties((Element)hercules.addEdge("battled", cerberus), (Object[])new Object[]{"time", 12, "place", Geoshape.point(39.0f, 22.0f)});
        pluto.addEdge("brother", jupiter);
        pluto.addEdge("brother", neptune);
        pluto.addEdge("lives", tartarus).setProperty("reason", (Object)"no fear of death");
        pluto.addEdge("pet", cerberus);
        cerberus.addEdge("lives", tartarus);
        tx.commit();
    }

    public static void main(String[] args) {
        if (null == args || 1 != args.length) {
            System.err.println("Usage: GraphOfTheGodsFactory <titan-config-file>");
            System.exit(1);
        }
        TitanGraph g = TitanFactory.open(args[0]);
        GraphOfTheGodsFactory.load(g);
        g.shutdown();
    }
}

