/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import org.jboss.forge.addon.resource.AbstractFileResource;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.zip.ZipFileResource;
import org.jboss.forge.addon.resource.zip.ZipFileResourceEntryImpl;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Strings;

public class ZipFileResourceImpl
extends AbstractFileResource<ZipFileResource>
implements ZipFileResource {
    private final ZipFile zipFile;

    public ZipFileResourceImpl(ResourceFactory resourceFactory, File file) {
        super(resourceFactory, file);
        try {
            this.zipFile = new ZipFile(file);
        }
        catch (ZipException e) {
            throw new ResourceException("Error while creating ZipFile", (Throwable)e);
        }
    }

    ZipFile getZipFile() {
        return this.zipFile;
    }

    public Resource<File> createFrom(File file) {
        return new ZipFileResourceImpl(this.getResourceFactory(), file);
    }

    public Resource<?> getChild(String name) {
        FileHeader fileHeader;
        try {
            fileHeader = this.zipFile.getFileHeader(name);
        }
        catch (ZipException e) {
            throw new ResourceException("Error while fetching file header", (Throwable)e);
        }
        return fileHeader == null ? null : new ZipFileResourceEntryImpl(this.getResourceFactory(), this, fileHeader);
    }

    protected List<Resource<?>> doListResources() {
        ArrayList entries = new ArrayList();
        try {
            List fileHeaders = this.zipFile.getFileHeaders();
            for (FileHeader fileHeader : fileHeaders) {
                entries.add((Resource<?>)new ZipFileResourceEntryImpl(this.getResourceFactory(), this, fileHeader));
            }
        }
        catch (ZipException e) {
            throw new ResourceException("Error while listing children", (Throwable)e);
        }
        return entries;
    }

    public void extractTo(DirectoryResource directoryResource) {
        try {
            this.getZipFile().extractAll(directoryResource.getFullyQualifiedName());
        }
        catch (ZipException e) {
            throw new ResourceException("Error while unzipping files", (Throwable)e);
        }
    }

    public boolean isEncrypted() {
        try {
            return this.getZipFile().isEncrypted();
        }
        catch (ZipException e) {
            throw new ResourceException("Error while checking if file is encrypted", (Throwable)e);
        }
    }

    public ZipFileResource setPassword(char[] password) {
        try {
            this.getZipFile().setPassword(password);
        }
        catch (ZipException e) {
            throw new ResourceException("Error while setting the zip password", (Throwable)e);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public ZipFileResource add(FileResource<?> ... resources) {
        void var6_9;
        Assert.notNull(resources, (String)"You cannot add null resources to a zip file");
        ArrayList<Object> files = new ArrayList<Object>(resources.length);
        ArrayList<Object> directories = new ArrayList<Object>(resources.length);
        FileResource<?>[] fileResourceArray = resources;
        int n = fileResourceArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            FileResource<?> resource = fileResourceArray[var6_9];
            if (resource.isDirectory()) {
                directories.add(resource.getUnderlyingResourceObject());
            } else {
                files.add(resource.getUnderlyingResourceObject());
            }
            ++var6_9;
        }
        try {
            ZipParameters parameters = new ZipParameters();
            for (File file : directories) {
                this.getZipFile().addFolder(file, parameters);
            }
            if (files.size() > 0) {
                this.getZipFile().addFiles(files, parameters);
            }
        }
        catch (ZipException e) {
            throw new ResourceException("Error while adding files to zip file", (Throwable)e);
        }
        return this;
    }

    public ZipFileResource add(String name, Resource<?> resource) {
        block16: {
            Assert.isTrue((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"You need to specify a name for the Resource");
            Assert.notNull(resource, (String)"You cannot add a null Resource to a zip file");
            try {
                ZipParameters parameters = new ZipParameters();
                parameters.setFileNameInZip(name);
                if (resource instanceof DirectoryResource) {
                    for (Resource child : resource.listResources()) {
                        this.add(name + File.separatorChar + child.getName(), child);
                    }
                    break block16;
                }
                parameters.setSourceExternalStream(true);
                try (InputStream stream = resource.getResourceInputStream();){
                    this.getZipFile().addStream(stream, parameters);
                }
            }
            catch (IOException | ZipException e) {
                throw new ResourceException("Error while adding files to zip file", e);
            }
        }
        return this;
    }
}

