/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.bridge.server.conversation;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.work.WorkException;
import org.xadisk.bridge.proxies.impl.RemoteLock;
import org.xadisk.bridge.proxies.impl.RemoteMessageEndpoint;
import org.xadisk.bridge.proxies.impl.RemoteSession;
import org.xadisk.bridge.proxies.impl.RemoteXAFileInputStream;
import org.xadisk.bridge.proxies.impl.RemoteXAFileOutputStream;
import org.xadisk.bridge.proxies.interfaces.Session;
import org.xadisk.bridge.proxies.interfaces.XAFileInputStream;
import org.xadisk.bridge.proxies.interfaces.XAFileOutputStream;
import org.xadisk.bridge.server.conversation.ConversationalHostedContext;
import org.xadisk.bridge.server.conversation.HostedContext;
import org.xadisk.bridge.server.conversation.RemoteMethodInvocationHandler;
import org.xadisk.filesystem.Lock;
import org.xadisk.filesystem.NativeSession;
import org.xadisk.filesystem.NativeXAFileSystem;

public class ConversationContext {
    private final SocketChannel conversationChannel;
    private int currentMethodInvocationLength = -1;
    private ByteBuffer currentInvocationLengthBytes = ByteBuffer.allocate(4);
    private ByteBuffer currentMethodInvocationBuffer;
    private byte[] currentMethodInvocation;
    private final HostedContext conversationalHostedContext;
    private final HostedContext globalHostedContext;
    private final ArrayList<NativeSession> allSessionsInsideThisConversation = new ArrayList();
    private final NativeXAFileSystem xaFileSystem;

    public ConversationContext(SocketChannel conversationChannel, NativeXAFileSystem xaFileSystem) {
        this.xaFileSystem = xaFileSystem;
        this.conversationChannel = conversationChannel;
        this.conversationalHostedContext = new ConversationalHostedContext();
        this.conversationalHostedContext.hostObject(xaFileSystem);
        this.conversationalHostedContext.hostObject(xaFileSystem.getConcurrencyControl());
        this.globalHostedContext = xaFileSystem.getGlobalCallbackContext();
    }

    public Object getLocalObjectFromProxy(long objectId) {
        if (objectId < 0L) {
            return this.globalHostedContext.getHostedObjectWithId(objectId);
        }
        return this.conversationalHostedContext.getHostedObjectWithId(objectId);
    }

    public SocketChannel getConversationChannel() {
        return this.conversationChannel;
    }

    public byte[] getCurrentMethodInvocation() {
        return this.currentMethodInvocation;
    }

    public void updateWithConversation(ByteBuffer buffer) throws WorkException, IOException {
        if (this.currentMethodInvocationLength == -1) {
            byte[] t = new byte[Math.min(this.currentInvocationLengthBytes.remaining(), buffer.remaining())];
            buffer.get(t);
            this.currentInvocationLengthBytes.put(t);
            if (this.currentInvocationLengthBytes.position() == 4) {
                this.currentInvocationLengthBytes.flip();
                this.currentMethodInvocationLength = this.getIntegerFromDataOutputCompliantBytes(this.currentInvocationLengthBytes);
            }
        }
        if (this.currentMethodInvocationLength != -1) {
            if (this.currentMethodInvocationBuffer == null) {
                this.currentMethodInvocationBuffer = ByteBuffer.allocate(this.currentMethodInvocationLength);
            }
            this.currentMethodInvocationBuffer.put(buffer);
            if (this.currentMethodInvocationBuffer.position() == this.currentMethodInvocationLength) {
                this.currentMethodInvocation = new byte[this.currentMethodInvocationLength];
                this.currentMethodInvocationBuffer.flip();
                this.currentMethodInvocationBuffer.get(this.currentMethodInvocation);
                this.clearLastConversation();
                RemoteMethodInvocationHandler handleRemoteMethodInvocation = new RemoteMethodInvocationHandler(this, this.xaFileSystem);
                this.xaFileSystem.startWork(handleRemoteMethodInvocation);
            }
        }
    }

    private void clearLastConversation() {
        this.currentMethodInvocationLength = -1;
        this.currentInvocationLengthBytes.clear();
        this.currentMethodInvocationBuffer = null;
    }

    Object convertToProxyResponseIfRequired(Object response) {
        if (this.xaFileSystem.getHandleGeneralRemoteInvocations()) {
            if (response instanceof Session) {
                this.allSessionsInsideThisConversation.add((NativeSession)response);
                return new RemoteSession(this.conversationalHostedContext.hostObject(response), null);
            }
            if (response instanceof XAFileInputStream) {
                return new RemoteXAFileInputStream(this.conversationalHostedContext.hostObject(response), null);
            }
            if (response instanceof XAFileOutputStream) {
                return new RemoteXAFileOutputStream(this.conversationalHostedContext.hostObject(response), null);
            }
            if (response instanceof MessageEndpoint) {
                return new RemoteMessageEndpoint(this.globalHostedContext.hostObject(response), null);
            }
        }
        if (this.xaFileSystem.getHandleClusterRemoteInvocations() && response instanceof Lock) {
            Lock lock = (Lock)response;
            return new RemoteLock(this.conversationalHostedContext.hostObject(response), lock.getResource(), lock.isExclusive());
        }
        return response;
    }

    private int getIntegerFromDataOutputCompliantBytes(ByteBuffer b) {
        return (b.get() & 0xFF) << 24 | (b.get() & 0xFF) << 16 | (b.get() & 0xFF) << 8 | b.get() & 0xFF;
    }
}

