/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.iteration.AbstractIterationFilter;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.DiscoverProjectStructurePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.DuplicateArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.ProjectService;
import org.jboss.windup.rules.apps.java.scan.provider.DiscoverMavenProjectsRuleProvider;
import org.jboss.windup.util.ZipUtil;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=DiscoverProjectStructurePhase.class, after={DiscoverMavenProjectsRuleProvider.class})
public class DiscoverNonMavenArchiveProjectsRuleProvider
extends AbstractRuleProvider {
    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(ArchiveModel.class)).perform((Operation)Iteration.over(ArchiveModel.class).when((Condition)new AbstractIterationFilter<ArchiveModel>(){

            public boolean evaluate(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
                return !(payload instanceof DuplicateArchiveModel) && payload.getProjectModel() == null;
            }

            public String toString() {
                return "ProjectModel == null";
            }
        }).perform((Operation)new AbstractIterationOperation<ArchiveModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
                ArrayList<ArchiveModel> hierarchy = new ArrayList<ArchiveModel>();
                for (ArchiveModel parentArchive = payload; parentArchive != null; parentArchive = parentArchive.getParentArchive()) {
                    hierarchy.add(parentArchive);
                    if (parentArchive.getProjectModel() != null) break;
                }
                ProjectModel childProjectModel = null;
                ProjectService projectModelService = new ProjectService(event.getGraphContext());
                for (ArchiveModel archiveModel : hierarchy) {
                    ProjectModel projectModel = archiveModel.getProjectModel();
                    if (projectModel == null) {
                        projectModel = (ProjectModel)projectModelService.create();
                        projectModel.setName(archiveModel.getArchiveName());
                        projectModel.setRootFileModel((FileModel)archiveModel);
                        projectModel.setDescription("Unidentified Archive");
                        if (ZipUtil.endsWithZipExtension((String)archiveModel.getArchiveName())) {
                            for (String extension : ZipUtil.getZipExtensions()) {
                                if (!archiveModel.getArchiveName().endsWith(extension)) continue;
                                projectModel.setProjectType(extension);
                            }
                        }
                        projectModel.addFileModel((FileModel)archiveModel);
                        for (FileModel f : archiveModel.getAllFiles()) {
                            if (f instanceof ArchiveModel) continue;
                            if (f.asVertex().getVertices(Direction.IN, new String[]{"projectModelToFile"}).iterator().hasNext()) continue;
                            projectModel.addFileModel(f);
                        }
                    }
                    if (childProjectModel != null) {
                        childProjectModel.setParentProject(projectModel);
                    }
                    childProjectModel = projectModel;
                }
            }

            public String toString() {
                return "ScanAsNonMavenProject";
            }
        }.and((Operation)IterationProgress.monitoring((String)"Checking for non-Maven archive", (int)1))).endIteration());
    }
}

