/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.service;

import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaMethodModel;
import org.jboss.windup.rules.apps.java.model.JavaParameterModel;
import org.jboss.windup.rules.apps.java.service.JavaParameterService;

public class JavaMethodService
extends GraphService<JavaMethodModel> {
    private final JavaParameterService paramService;

    public JavaMethodService(GraphContext context) {
        super(context, JavaMethodModel.class);
        this.paramService = new JavaParameterService(context);
    }

    public synchronized JavaMethodModel createJavaMethod(JavaClassModel clz, String javaMethod, JavaClassModel ... params) {
        for (JavaMethodModel method : clz.getMethod(javaMethod)) {
            if (method.countParameters() != (long)params.length || !this.methodParametersMatch(method, params)) continue;
            return method;
        }
        JavaMethodModel method = (JavaMethodModel)this.create();
        method.setMethodName(javaMethod);
        int j = params.length;
        for (int i = 0; i < j; ++i) {
            JavaParameterModel param = (JavaParameterModel)this.paramService.create();
            param.setPosition(i);
            param.setJavaType(params[i]);
        }
        return method;
    }

    protected boolean methodParametersMatch(JavaMethodModel method, JavaClassModel ... params) {
        int j = params.length;
        for (int i = 0; i < j; ++i) {
            JavaParameterModel param = method.getParameter(i);
            JavaClassModel paramVal = param.getJavaType();
            if (StringUtils.equals((CharSequence)paramVal.getQualifiedName(), (CharSequence)paramVal.getQualifiedName())) continue;
            return false;
        }
        return true;
    }
}

