/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberList;
import com.strobel.reflection.MethodInfo;
import java.util.ArrayList;
import java.util.List;

public final class MethodList
extends MemberList<MethodInfo> {
    private static final MethodList EMPTY = new MethodList(new MethodInfo[0]);

    public static MethodList empty() {
        return EMPTY;
    }

    public static MethodList combine(MethodList first, MethodList second) {
        VerifyArgument.notNull((Object)((Object)first), (String)"first");
        VerifyArgument.notNull((Object)((Object)second), (String)"second");
        if (first.isEmpty()) {
            return second;
        }
        if (second.isEmpty()) {
            return first;
        }
        ArrayList methods = new ArrayList(first.size() + second.size());
        methods.addAll(first);
        methods.addAll(second);
        return new MethodList(methods);
    }

    public MethodList(List<? extends MethodInfo> elements) {
        super(MethodInfo.class, elements);
    }

    public MethodList(MethodInfo ... elements) {
        super(MethodInfo.class, (MemberInfo[])elements);
    }

    public MethodList(MethodInfo[] elements, int offset, int length) {
        super(MethodInfo.class, (MemberInfo[])elements, offset, length);
    }

    @Override
    @NotNull
    public MethodList subList(int fromIndex, int toIndex) {
        MethodList.subListRangeCheck((int)fromIndex, (int)toIndex, (int)this.size());
        int offset = this.getOffset() + fromIndex;
        int length = toIndex - fromIndex;
        if (length == 0) {
            return MethodList.empty();
        }
        return new MethodList((MethodInfo[])this.getElements(), offset, length);
    }
}

