/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.FramedGraphQuery;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryGremlinCriterion;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.DataSourceModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.model.HibernateSessionFactoryModel;
import org.jboss.windup.rules.apps.javaee.service.DataSourceService;
import org.jboss.windup.rules.apps.javaee.service.HibernateConfigurationFileService;
import org.jboss.windup.rules.apps.javaee.util.HibernateDialectDataSourceTypeResolver;
import org.jboss.windup.rules.apps.xml.model.DoctypeMetaModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.Logging;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, perform="Discover hibernate.cfg.xml files")
public class DiscoverHibernateConfigurationRuleProvider
extends IteratingRuleProvider<DoctypeMetaModel> {
    private static final Logger LOG = Logging.get(DiscoverHibernateConfigurationRuleProvider.class);
    private static final String TECH_TAG = "Hibernate Cfg";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.IMPORTANT;
    private static final String REGEX_HIBERNATE = "(?i).*hibernate.configuration.*";

    public ConditionBuilder when() {
        QueryGremlinCriterion doctypeSearchCriterion = new QueryGremlinCriterion(){

            public void query(GraphRewrite event, GremlinPipeline<Vertex, Vertex> pipeline) {
                pipeline.has("DoctypeMeta:publicId", (Predicate)Text.REGEX, (Object)DiscoverHibernateConfigurationRuleProvider.REGEX_HIBERNATE);
                FramedGraphQuery systemIDQuery = event.getGraphContext().getQuery().type(DoctypeMetaModel.class).has("DoctypeMeta:systemId", (Predicate)Text.REGEX, (Object)DiscoverHibernateConfigurationRuleProvider.REGEX_HIBERNATE);
                GremlinPipeline systemIdPipeline = new GremlinPipeline((Object)systemIDQuery.vertices());
                pipeline.add((Pipe)systemIdPipeline);
                pipeline.dedup();
            }
        };
        return Query.fromType(DoctypeMetaModel.class).piped(doctypeSearchCriterion);
    }

    public void perform(GraphRewrite event, EvaluationContext context, DoctypeMetaModel payload) {
        String publicId = payload.getPublicId();
        String systemId = payload.getSystemId();
        String versionInformation = this.extractVersion(publicId, systemId);
        for (XmlFileModel xml : payload.getXmlResources()) {
            this.createHibernateConfigurationModel(event, context, xml, versionInformation);
        }
    }

    private void createHibernateConfigurationModel(GraphRewrite event, EvaluationContext context, XmlFileModel xmlFileModel, String versionInformation) {
        GraphContext graphContext = event.getGraphContext();
        DataSourceService dataSourceService = new DataSourceService(graphContext);
        HibernateConfigurationFileService hibernateConfigurationFileService = new HibernateConfigurationFileService(graphContext);
        GraphService hibernateSessionFactoryService = new GraphService(graphContext, HibernateSessionFactoryModel.class);
        TechnologyTagService technologyTagService = new TechnologyTagService(graphContext);
        HibernateConfigurationFileModel hibernateConfigurationModel = (HibernateConfigurationFileModel)hibernateConfigurationFileService.addTypeToModel((WindupVertexFrame)xmlFileModel);
        technologyTagService.addTagToFileModel((FileModel)hibernateConfigurationModel, TECH_TAG, TECH_TAG_LEVEL);
        if (StringUtils.isNotBlank((CharSequence)versionInformation)) {
            hibernateConfigurationModel.setSpecificationVersion(versionInformation);
        }
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)xmlFileModel.getProjectModel());
        Document doc = new XmlFileService(graphContext).loadDocumentQuiet(event, context, xmlFileModel);
        for (Element element : JOOX.$((Document)doc).find("session-factory").get()) {
            String dialect;
            String resolvedType;
            HibernateSessionFactoryModel sessionFactoryModel = (HibernateSessionFactoryModel)hibernateSessionFactoryService.create();
            hibernateConfigurationModel.addHibernateSessionFactory(sessionFactoryModel);
            HashMap<String, String> sessionFactoryProperties = new HashMap<String, String>();
            for (Element propElement : JOOX.$((Element)element).find("property")) {
                String propKey = JOOX.$((Element)propElement).attr("name");
                String propValue = JOOX.$((Element)propElement).text().trim();
                sessionFactoryProperties.put(propKey, propValue);
            }
            sessionFactoryModel.setSessionFactoryProperties(sessionFactoryProperties);
            if (!sessionFactoryProperties.containsKey("hibernate.connection.datasource")) continue;
            String dataSourceJndiName = (String)sessionFactoryProperties.get("hibernate.connection.datasource");
            String dataSourceName = dataSourceJndiName;
            if (StringUtils.contains((CharSequence)dataSourceName, (CharSequence)"/")) {
                dataSourceName = StringUtils.substringAfterLast((String)dataSourceName, (String)"/");
            }
            DataSourceModel dataSource = dataSourceService.createUnique(applications, dataSourceName, dataSourceJndiName);
            if (!sessionFactoryProperties.containsKey("hibernate.dialect") || !StringUtils.isNotBlank((CharSequence)(resolvedType = HibernateDialectDataSourceTypeResolver.resolveDataSourceTypeFromDialect(dialect = (String)sessionFactoryProperties.get("hibernate.dialect"))))) continue;
            dataSource.setDatabaseTypeName(resolvedType);
        }
    }

    private String extractVersion(String publicId, String systemId) {
        Matcher matcher;
        Pattern pattern = Pattern.compile("[0-9][0-9a-zA-Z.-]+");
        if (StringUtils.isNotBlank((CharSequence)publicId) && (matcher = pattern.matcher(publicId)).find()) {
            return matcher.group();
        }
        if (StringUtils.isNotBlank((CharSequence)systemId) && (matcher = pattern.matcher(systemId)).find()) {
            String match = matcher.group();
            return StringUtils.removeEnd((String)match, (String)".dtd");
        }
        return null;
    }
}

