/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.DiscoverProjectStructurePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.query.QueryBuilderWith;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectDependencyModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.FileService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.project.MavenProjectModel;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMapping;
import org.jboss.windup.rules.apps.maven.dao.MavenProjectService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.exception.MarshallingException;
import org.jboss.windup.util.xml.XmlUtil;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RuleMetadata(phase=DiscoverProjectStructurePhase.class, haltOnException=true)
public class DiscoverMavenProjectsRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(DiscoverMavenProjectsRuleProvider.class);
    private static final Map<String, String> namespaces = new HashMap<String, String>();

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        QueryBuilderWith fileWhen = Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"pom.xml");
        AbstractIterationOperation<XmlFileModel> evaluatePomFiles = new AbstractIterationOperation<XmlFileModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
                block3: {
                    MavenProjectModel mavenProjectModel;
                    block4: {
                        if (payload.getProjectModel() != null) {
                            return;
                        }
                        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
                        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
                        String defaultName = payload.getArchive() == null ? payload.asFile().getParentFile().getName() : payload.getArchive().getFileName();
                        mavenProjectModel = DiscoverMavenProjectsRuleProvider.this.extractMavenProjectModel(event, context, defaultName, payload);
                        if (mavenProjectModel == null) break block3;
                        classificationService.attachClassification(event, context, (FileModel)payload, "Maven POM", "Maven Project Object Model (POM) File");
                        technologyTagService.addTagToFileModel((FileModel)payload, "Maven XML", TechnologyTagLevel.INFORMATIONAL);
                        ArchiveModel archiveModel = payload.getArchive();
                        if (archiveModel == null || DiscoverMavenProjectsRuleProvider.this.isAlreadyMavenProject((FileModel)archiveModel)) break block4;
                        mavenProjectModel.addFileModel((FileModel)archiveModel);
                        mavenProjectModel.setRootFileModel((FileModel)archiveModel);
                        for (FileModel f : archiveModel.getAllFiles()) {
                            if (f instanceof ArchiveModel || f.getProjectModel() != null) continue;
                            mavenProjectModel.addFileModel(f);
                        }
                        break block3;
                    }
                    File parentFile = payload.asFile().getParentFile();
                    FileModel parentFileModel = new FileService(event.getGraphContext()).findByPath(parentFile.getAbsolutePath());
                    if (parentFileModel == null || DiscoverMavenProjectsRuleProvider.this.isAlreadyMavenProject(parentFileModel)) break block3;
                    mavenProjectModel.addFileModel(parentFileModel);
                    mavenProjectModel.setRootFileModel(parentFileModel);
                    for (FileModel childFile : parentFileModel.getFilesInDirectory()) {
                        DiscoverMavenProjectsRuleProvider.this.addFilesToModel(mavenProjectModel, childFile);
                    }
                }
            }

            public String toString() {
                return "ScanMavenProject";
            }
        };
        return ConfigurationBuilder.begin().addRule().when((Condition)fileWhen).perform((Operation)evaluatePomFiles);
    }

    private boolean isAlreadyMavenProject(FileModel fileModel) {
        return fileModel.getProjectModel() != null && fileModel.getProjectModel() instanceof MavenProjectModel;
    }

    private void addFilesToModel(MavenProjectModel mavenProjectModel, FileModel fileModel) {
        for (FileModel childFile : fileModel.getFilesInDirectory()) {
            String filename = childFile.getFileName();
            if (!filename.equals("pom.xml")) continue;
            return;
        }
        mavenProjectModel.addFileModel(fileModel);
        for (FileModel childFile : fileModel.getFilesInDirectory()) {
            this.addFilesToModel(mavenProjectModel, childFile);
        }
    }

    public MavenProjectModel extractMavenProjectModel(GraphRewrite event, EvaluationContext context, String defaultProjectName, XmlFileModel xmlFileModel) {
        MavenProjectService mavenProjectService;
        MavenProjectModel mavenProjectModel;
        Document document;
        try {
            document = new XmlFileService(event.getGraphContext()).loadDocument(event, context, xmlFileModel);
        }
        catch (Exception ex) {
            xmlFileModel.setParseError("Could not parse POM XML: " + ex.getMessage());
            LOG.warning("Could not parse POM XML for '" + xmlFileModel.getFilePath() + "':\n\t" + ex.getMessage() + "\n\tSkipping Maven project discovery.");
            return null;
        }
        File xmlFile = xmlFileModel.asFile();
        String modelVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:modelVersion | /project/modelVersion", namespaces);
        String name = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:name | /project/name", namespaces);
        String organization = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:organization | /project/organization", namespaces);
        String description = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:description | /project/description", namespaces);
        String url = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:url | /project/url", namespaces);
        String groupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:groupId | /project/groupId", namespaces);
        String artifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:artifactId | /project/artifactId", namespaces);
        String version = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:version | /project/version", namespaces);
        String parentGroupId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:groupId | /project/parent/groupId", namespaces);
        String parentArtifactId = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:artifactId | /project/parent/artifactId", namespaces);
        String parentVersion = XmlUtil.xpathExtract((Node)document, (String)"/pom:project/pom:parent/pom:version | /project/parent/version", namespaces);
        if (StringUtils.isBlank((CharSequence)groupId) && StringUtils.isNotBlank((CharSequence)parentGroupId)) {
            groupId = parentGroupId;
        }
        if (StringUtils.isBlank((CharSequence)version) && StringUtils.isNotBlank((CharSequence)parentVersion)) {
            version = parentVersion;
        }
        if (StringUtils.isBlank((CharSequence)organization)) {
            organization = PackageNameMapping.getOrganizationForPackage(event, groupId);
        }
        if ((mavenProjectModel = this.getMavenStubProject(mavenProjectService = new MavenProjectService(event.getGraphContext()), groupId, artifactId, version)) == null) {
            LOG.info("Creating maven project for pom at: " + xmlFileModel.getFilePath() + " with gav: " + groupId + "," + artifactId + "," + version);
            mavenProjectModel = mavenProjectService.createMavenStub(groupId, artifactId, version);
            mavenProjectModel.addMavenPom(xmlFileModel);
        } else {
            boolean found = false;
            for (XmlFileModel foundPom : mavenProjectModel.getMavenPom()) {
                File foundPomFile = foundPom.asFile();
                if (!foundPomFile.getAbsoluteFile().equals(xmlFile)) continue;
                found = true;
                break;
            }
            if (!found) {
                mavenProjectModel.addMavenPom(xmlFileModel);
            }
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = defaultProjectName;
        }
        mavenProjectModel.setName(this.getReadableNameForProject(name, groupId, artifactId, version));
        if (StringUtils.isNotBlank((CharSequence)organization)) {
            mavenProjectModel.setOrganization(organization);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            mavenProjectModel.setDescription(StringUtils.trim((String)description));
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            mavenProjectModel.setURL(StringUtils.trim((String)url));
        }
        if (StringUtils.isNotBlank((CharSequence)modelVersion)) {
            mavenProjectModel.setSpecificationVersion(modelVersion);
        }
        if (StringUtils.isNotBlank((CharSequence)parentGroupId)) {
            MavenProjectModel parent = this.getMavenProject(mavenProjectService, parentGroupId = this.resolveProperty(document, namespaces, parentGroupId, version), parentArtifactId = this.resolveProperty(document, namespaces, parentArtifactId, version), parentVersion = this.resolveProperty(document, namespaces, parentVersion, version));
            if (parent == null) {
                parent = mavenProjectService.createMavenStub(parentGroupId, parentArtifactId, parentVersion);
                parent.setName(this.getReadableNameForProject(null, parentGroupId, parentArtifactId, parentVersion));
            }
            mavenProjectModel.setParentMavenPOM(parent);
        }
        NodeList nodes = XmlUtil.xpathNodeList((Node)document, (String)"/pom:project/pom:dependencies/pom:dependency | /project/dependencies/dependency", namespaces);
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            Node node = nodes.item(i);
            String dependencyGroupId = XmlUtil.xpathExtract((Node)node, (String)"./pom:groupId | ./groupId", namespaces);
            String dependencyArtifactId = XmlUtil.xpathExtract((Node)node, (String)"./pom:artifactId | ./artifactId", namespaces);
            String dependencyVersion = XmlUtil.xpathExtract((Node)node, (String)"./pom:version | ./version", namespaces);
            String dependencyClassifier = XmlUtil.xpathExtract((Node)node, (String)"./pom:classifier | ./classifier", namespaces);
            String dependencyScope = XmlUtil.xpathExtract((Node)node, (String)"./pom:scope | ./scope", namespaces);
            String dependencyType = XmlUtil.xpathExtract((Node)node, (String)"./pom:type | ./type", namespaces);
            dependencyGroupId = this.resolveProperty(document, namespaces, dependencyGroupId, version);
            dependencyArtifactId = this.resolveProperty(document, namespaces, dependencyArtifactId, version);
            dependencyVersion = this.resolveProperty(document, namespaces, dependencyVersion, version);
            if (!StringUtils.isNotBlank((CharSequence)dependencyGroupId)) continue;
            MavenProjectModel dependency = this.getMavenProject(mavenProjectService, dependencyGroupId, dependencyArtifactId, dependencyVersion);
            if (dependency == null) {
                dependency = mavenProjectService.createMavenStub(dependencyGroupId, dependencyArtifactId, dependencyVersion);
                dependency.setName(this.getReadableNameForProject(null, dependencyGroupId, dependencyArtifactId, dependencyVersion));
            }
            ProjectDependencyModel projectDep = (ProjectDependencyModel)new GraphService(event.getGraphContext(), ProjectDependencyModel.class).create();
            projectDep.setClassifier(dependencyClassifier);
            projectDep.setScope(dependencyScope);
            projectDep.setType(dependencyType);
            projectDep.setProject((ProjectModel)dependency);
            mavenProjectModel.addDependency(projectDep);
        }
        return mavenProjectModel;
    }

    private MavenProjectModel getMavenProject(MavenProjectService mavenProjectService, String groupId, String artifactId, String version) {
        Iterable<MavenProjectModel> possibleProjects = mavenProjectService.findByGroupArtifactVersion(groupId, artifactId, version);
        MavenProjectModel project = null;
        for (MavenProjectModel possibleProject : possibleProjects) {
            if (possibleProject.getRootFileModel() != null) {
                return possibleProject;
            }
            if (project != null) continue;
            project = possibleProject;
        }
        return project;
    }

    private MavenProjectModel getMavenStubProject(MavenProjectService mavenProjectService, String groupId, String artifactId, String version) {
        Iterable<MavenProjectModel> mavenProjectModels = mavenProjectService.findByGroupArtifactVersion(groupId, artifactId, version);
        if (!mavenProjectModels.iterator().hasNext()) {
            return null;
        }
        for (MavenProjectModel mavenProjectModel : mavenProjectModels) {
            if (mavenProjectModel.getRootFileModel() != null) continue;
            return mavenProjectModel;
        }
        return null;
    }

    private String getReadableNameForProject(String mavenName, String groupId, String artifactId, String version) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)mavenName)) {
            sb.append(mavenName);
        } else if (StringUtils.isNotBlank((CharSequence)groupId) || StringUtils.isNotBlank((CharSequence)artifactId) || StringUtils.isNotBlank((CharSequence)version)) {
            sb.append(groupId).append(":").append(artifactId).append(":").append(version);
        }
        return sb.toString();
    }

    private String resolveProperty(Document document, Map<String, String> namespaces, String property, String projectVersion) throws MarshallingException {
        if (StringUtils.startsWith((CharSequence)property, (CharSequence)"${")) {
            String propertyName = StringUtils.removeStart((String)property, (String)"${");
            switch (propertyName = StringUtils.removeEnd((String)propertyName, (String)"}")) {
                case "pom.version": 
                case "project.version": {
                    return projectVersion;
                }
            }
            NodeList nodes = XmlUtil.xpathNodeList((Node)document, (String)("//pom:properties/pom:" + propertyName + " | //properties/" + propertyName), namespaces);
            if (nodes.getLength() == 0 || nodes.item(0) == null) {
                LOG.warning("Expected: " + property + " but it wasn't found in the POM.");
            } else {
                Node node = nodes.item(0);
                return node.getTextContent();
            }
        }
        return property;
    }

    static {
        namespaces.put("pom", "http://maven.apache.org/POM/4.0.0");
    }
}

