/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.xml.confighandler;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.exception.ConfigurationException;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.rules.apps.xml.confighandler.XSLTParameter;
import org.jboss.windup.rules.apps.xml.operation.xslt.XSLTTransformation;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="xslt", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class XSLTTransformationHandler
implements ElementHandler<XSLTTransformation> {
    public XSLTTransformation processElement(ParserContext handlerManager, Element element) throws ConfigurationException {
        String description = JOOX.$((Element)element).attr("title");
        String extension = JOOX.$((Element)element).attr("extension");
        String effort = JOOX.$((Element)element).attr("effort");
        String template = JOOX.$((Element)element).attr("template");
        String of = JOOX.$((Element)element).attr("of");
        if (StringUtils.isBlank((CharSequence)description)) {
            throw new WindupException("Error, 'xslt' element must have a non-empty 'description' attribute");
        }
        if (StringUtils.isBlank((CharSequence)template)) {
            throw new WindupException("Error, 'xslt' element must have a non-empty 'template' attribute");
        }
        if (StringUtils.isBlank((CharSequence)extension)) {
            throw new WindupException("Error, 'xslt' element must have a non-empty 'extension' attribute");
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        List children = JOOX.$((Element)element).children("xslt-parameter").get();
        for (Element child : children) {
            XSLTParameter param = (XSLTParameter)handlerManager.processElement(child);
            parameters.put(param.getKey(), param.getValue());
        }
        Path pathContainingXml = handlerManager.getXmlInputRootPath();
        if (pathContainingXml != null) {
            String fullPath;
            if (template.startsWith("/") || template.startsWith("\\")) {
                fullPath = template;
            } else {
                Path path = pathContainingXml.resolve(template).toAbsolutePath();
                if (!Files.exists(path, new LinkOption[0])) {
                    Path rulesParentPath = handlerManager.getXmlInputPath().getParent();
                    fullPath = rulesParentPath.resolve(template).normalize().toAbsolutePath().toString();
                } else {
                    fullPath = path.normalize().toString();
                }
            }
            XSLTTransformation transformation = (XSLTTransformation)XSLTTransformation.usingFilesystem(fullPath).withDescription(description).withExtension(extension).withParameters(parameters);
            if (of != null) {
                transformation = (XSLTTransformation)XSLTTransformation.of(of).usingTemplate(fullPath).withDescription(description).withExtension(extension).withParameters(parameters);
                return transformation;
            }
            return transformation.withEffort(effort == null ? 0 : Integer.valueOf(effort));
        }
        ClassLoader xmlFileAddonClassLoader = handlerManager.getAddonContainingInputXML().getClassLoader();
        if (of != null) {
            return (XSLTTransformation)XSLTTransformation.of(of).usingTemplate(template, xmlFileAddonClassLoader).withDescription(description).withExtension(extension).withParameters(parameters);
        }
        return (XSLTTransformation)XSLTTransformation.using(template, xmlFileAddonClassLoader).withDescription(description).withExtension(extension).withParameters(parameters);
    }
}

