/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.exception.WindupException;

public class ReportService
extends GraphService<ReportModel> {
    private static final String REPORTS_DIR = "reports";
    private static final String DATA = "data";
    private static final Set<String> usedFilenames = new HashSet<String>();
    private final AtomicInteger index = new AtomicInteger(1);

    public ReportService(GraphContext context) {
        super(context, ReportModel.class);
    }

    public Path getReportDataDirectory() {
        Path path = this.getReportDirectory().resolve(DATA);
        this.createDirectoryIfNeeded(path);
        return path;
    }

    public Path getReportDirectory() {
        WindupConfigurationModel cfg = WindupConfigurationService.getConfigurationModel((GraphContext)this.getGraphContext());
        Path path = cfg.getOutputPath().asFile().toPath().resolve(REPORTS_DIR);
        this.createDirectoryIfNeeded(path);
        return path.toAbsolutePath();
    }

    private void createDirectoryIfNeeded(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new WindupException("Failed to create directory: " + path.toString() + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public <T extends ReportModel> T getReportByName(String name, Class<T> clazz) {
        WindupVertexFrame model = this.getUniqueByProperty("reportName", name);
        try {
            return (T)((ReportModel)model);
        }
        catch (ClassCastException ex) {
            throw new WindupException("The vertex is not of expected frame type " + clazz.getName() + ": " + model.toPrettyString());
        }
    }

    public void setUniqueFilename(ReportModel model, String baseFilename, String extension) {
        String filename = PathUtil.cleanFileName((String)baseFilename) + "." + extension;
        while (usedFilenames.contains(filename)) {
            filename = PathUtil.cleanFileName((String)baseFilename) + "." + this.index.getAndIncrement() + "." + extension;
        }
        usedFilenames.add(filename);
        model.setReportFilename(filename);
    }
}

