/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.graph;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.impl.graph.AddonDependencyEdge;
import org.jboss.forge.furnace.impl.graph.AddonGraph;
import org.jboss.forge.furnace.impl.graph.AddonVertex;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jboss.forge.furnace.versions.EmptyVersionRange;
import org.jboss.forge.furnace.versions.VersionRange;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.TraversalListenerAdapter;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;

public class OptimizedAddonGraph
extends AddonGraph<OptimizedAddonGraph> {
    private DirectedGraph<AddonVertex, AddonDependencyEdge> graph = new SimpleDirectedGraph(AddonDependencyEdge.class);
    private AddonView view;

    public OptimizedAddonGraph(AddonView view, final DirectedGraph<AddonVertex, AddonDependencyEdge> completeGraph) {
        this.view = view;
        DepthFirstIterator iterator = new DepthFirstIterator(completeGraph);
        iterator.addTraversalListener((TraversalListener)new TraversalListenerAdapter<AddonVertex, AddonDependencyEdge>(){

            public void vertexTraversed(VertexTraversalEvent<AddonVertex> event) {
                AddonVertex vertex = (AddonVertex)event.getVertex();
                Set incoming = completeGraph.incomingEdgesOf((Object)vertex);
                AddonVertex localVertex = OptimizedAddonGraph.this.getOrCreateVertex(vertex.getName(), EmptyVersion.getInstance());
                for (AddonDependencyEdge incomingEdge : incoming) {
                    AddonVertex source = (AddonVertex)completeGraph.getEdgeSource((Object)incomingEdge);
                    AddonVertex localSource = OptimizedAddonGraph.this.getOrCreateVertex(source.getName(), EmptyVersion.getInstance());
                    try {
                        OptimizedAddonGraph.this.graph.addEdge((Object)localSource, (Object)localVertex, (Object)new AddonDependencyEdge((VersionRange)new EmptyVersionRange(), incomingEdge.isExported()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        while (iterator.hasNext()) {
            iterator.next();
        }
        LinkedHashMap<AddonVertex, AddonVertex> replacements = new LinkedHashMap<AddonVertex, AddonVertex>();
        for (AddonVertex addonVertex : this.graph.vertexSet()) {
            for (AddonVertex vertex : completeGraph.vertexSet()) {
                if (!addonVertex.getName().equals(vertex.getName()) || !(addonVertex.getVersion() instanceof EmptyVersion) && addonVertex.getVersion().compareTo((Object)vertex.getVersion()) >= 1 || replacements.get(addonVertex) != null && ((AddonVertex)replacements.get(addonVertex)).getVersion().compareTo((Object)vertex.getVersion()) >= 1) continue;
                AddonVertex replacement = new AddonVertex(addonVertex.getName(), vertex.getVersion());
                replacements.put(addonVertex, replacement);
            }
        }
        for (Map.Entry entry : replacements.entrySet()) {
            this.replaceVertex((AddonVertex)entry.getKey(), (AddonVertex)entry.getValue());
        }
        CycleDetector detector = new CycleDetector(this.graph);
        if (detector.detectCycles()) {
            throw new IllegalStateException("Cycle detected in Addon graph: " + detector.findCycles());
        }
    }

    private void replaceVertex(AddonVertex original, AddonVertex replacement) {
        Set incoming = this.graph.incomingEdgesOf((Object)original);
        Set outgoing = this.graph.outgoingEdgesOf((Object)original);
        this.addLocalVertex(replacement);
        for (AddonDependencyEdge edge : incoming) {
            this.graph.addEdge(this.graph.getEdgeSource((Object)edge), (Object)replacement, (Object)new AddonDependencyEdge(edge.getVersionRange(), edge.isExported()));
        }
        for (AddonDependencyEdge edge : outgoing) {
            this.graph.addEdge((Object)replacement, this.graph.getEdgeTarget((Object)edge), (Object)new AddonDependencyEdge(edge.getVersionRange(), edge.isExported()));
        }
        this.graph.removeVertex((Object)original);
    }

    @Override
    public DirectedGraph<AddonVertex, AddonDependencyEdge> getGraph() {
        return this.graph;
    }

    public AddonView getAddonView() {
        return this.view;
    }
}

