/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.proxy.javassist;

import org.jboss.forge.furnace.proxy.javassist.ClassPool;
import org.jboss.forge.furnace.proxy.javassist.CtClass;
import org.jboss.forge.furnace.proxy.javassist.CtNewClass;
import org.jboss.forge.furnace.proxy.javassist.NotFoundException;
import org.jboss.forge.furnace.proxy.javassist.bytecode.ClassFile;
import org.jboss.forge.furnace.proxy.javassist.bytecode.InnerClassesAttribute;

class CtNewNestedClass
extends CtNewClass {
    CtNewNestedClass(String realName, ClassPool cp, boolean isInterface, CtClass superclass) {
        super(realName, cp, isInterface, superclass);
    }

    @Override
    public void setModifiers(int mod) {
        super.setModifiers(mod &= 0xFFFFFFF7);
        CtNewNestedClass.updateInnerEntry(mod, this.getName(), this, true);
    }

    private static void updateInnerEntry(int mod, String name, CtClass clazz, boolean outer) {
        ClassFile cf = clazz.getClassFile2();
        InnerClassesAttribute ica = (InnerClassesAttribute)cf.getAttribute("InnerClasses");
        if (ica == null) {
            return;
        }
        int n = ica.tableLength();
        for (int i = 0; i < n; ++i) {
            if (!name.equals(ica.innerClass(i))) continue;
            int acc = ica.accessFlags(i) & 8;
            ica.setAccessFlags(i, mod | acc);
            String outName = ica.outerClass(i);
            if (outName == null || !outer) break;
            try {
                CtClass parent = clazz.getClassPool().get(outName);
                CtNewNestedClass.updateInnerEntry(mod, name, parent, false);
                break;
            }
            catch (NotFoundException e) {
                throw new RuntimeException("cannot find the declaring class: " + outName);
            }
        }
    }
}

