/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.windup.ast.java.data.TypeReferenceLocation;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.AbstractJavaSourceModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationListTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationLiteralTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.annotations.JavaAnnotationTypeValueModel;
import org.jboss.windup.rules.apps.java.scan.provider.AnalyzeJavaFilesRuleProvider;
import org.jboss.windup.rules.apps.javaee.model.JPAEntityModel;
import org.jboss.windup.rules.apps.javaee.model.JPANamedQueryModel;
import org.jboss.windup.rules.apps.javaee.service.JPAEntityService;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={AnalyzeJavaFilesRuleProvider.class})
public class DiscoverJPAAnnotationsRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logging.get(DiscoverJPAAnnotationsRuleProvider.class);
    private static final String ENTITY_ANNOTATIONS = "entityAnnotations";
    private static final String TABLE_ANNOTATIONS_LIST = "tableAnnotations";
    private static final String NAMED_QUERY_LIST = "namedQuery";
    private static final String NAMED_QUERIES_LIST = "namedQueries";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        String ruleIDPrefix = ((Object)((Object)this)).getClass().getSimpleName();
        return ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"javax.persistence.Entity").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION}).as(ENTITY_ANNOTATIONS).or((Condition)JavaClass.references((String)"javax.persistence.Table").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION}).as(TABLE_ANNOTATIONS_LIST)).or((Condition)JavaClass.references((String)"javax.persistence.NamedQuery").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION}).as(NAMED_QUERY_LIST)).or((Condition)JavaClass.references((String)"javax.persistence.NamedQueries").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION}).as(NAMED_QUERIES_LIST))).perform((Operation)Iteration.over((String)ENTITY_ANNOTATIONS).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverJPAAnnotationsRuleProvider.this.extractEntityBeanMetadata(event, payload);
            }
        }).endIteration()).withId(ruleIDPrefix + "_JPAEntityBeanRule");
    }

    private String getAnnotationLiteralValue(JavaAnnotationTypeReferenceModel model, String name) {
        JavaAnnotationTypeValueModel valueModel = (JavaAnnotationTypeValueModel)model.getAnnotationValues().get(name);
        if (valueModel instanceof JavaAnnotationLiteralTypeValueModel) {
            JavaAnnotationLiteralTypeValueModel literalTypeValue = (JavaAnnotationLiteralTypeValueModel)valueModel;
            return literalTypeValue.getLiteralValue();
        }
        return null;
    }

    private void extractEntityBeanMetadata(GraphRewrite event, JavaTypeReferenceModel entityTypeReference) {
        Iterable namedQueryList;
        String tableName;
        LOG.log(Level.INFO, () -> "extractEntityBeanMetadata() with " + entityTypeReference.getDescription());
        entityTypeReference.getFile().setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel entityAnnotationTypeReference = (JavaAnnotationTypeReferenceModel)entityTypeReference;
        JavaAnnotationTypeReferenceModel tableAnnotationTypeReference = null;
        Iterable annotations_list = Variables.instance((GraphRewrite)event).findVariable(TABLE_ANNOTATIONS_LIST);
        if (annotations_list != null) {
            for (WindupVertexFrame annotationTypeReferenceBase : annotations_list) {
                JavaAnnotationTypeReferenceModel annotationTypeReference = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceBase;
                if (!annotationTypeReference.getFile().equals(entityTypeReference.getFile())) continue;
                tableAnnotationTypeReference = annotationTypeReference;
                break;
            }
        }
        JavaClassModel ejbClass = this.getJavaClass(entityTypeReference);
        String ejbName = this.getAnnotationLiteralValue(entityAnnotationTypeReference, "name");
        if (ejbName == null) {
            ejbName = ejbClass.getClassName();
        }
        String string = tableName = tableAnnotationTypeReference == null ? ejbName : this.getAnnotationLiteralValue(tableAnnotationTypeReference, "name");
        if (tableName == null) {
            tableName = ejbName;
        }
        String catalogName = tableAnnotationTypeReference == null ? null : this.getAnnotationLiteralValue(tableAnnotationTypeReference, "catalog");
        String schemaName = tableAnnotationTypeReference == null ? null : this.getAnnotationLiteralValue(tableAnnotationTypeReference, "schema");
        JPAEntityService jpaService = new JPAEntityService(event.getGraphContext());
        JPAEntityModel jpaEntity = (JPAEntityModel)jpaService.create();
        jpaEntity.setApplications(ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)entityTypeReference.getFile().getProjectModel()));
        jpaEntity.setEntityName(ejbName);
        jpaEntity.setJavaClass(ejbClass);
        jpaEntity.setTableName(tableName);
        jpaEntity.setCatalogName(catalogName);
        jpaEntity.setSchemaName(schemaName);
        GraphService namedQueryService = new GraphService(event.getGraphContext(), JPANamedQueryModel.class);
        Iterable namedQueriesList = Variables.instance((GraphRewrite)event).findVariable(NAMED_QUERIES_LIST);
        if (namedQueriesList != null) {
            for (WindupVertexFrame annotationTypeReferenceBase : namedQueriesList) {
                JavaAnnotationListTypeValueModel referenceList;
                JavaAnnotationTypeValueModel value;
                JavaAnnotationTypeReferenceModel annotationTypeReference = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceBase;
                if (!annotationTypeReference.getFile().equals(entityTypeReference.getFile()) || (value = (JavaAnnotationTypeValueModel)annotationTypeReference.getAnnotationValues().get("value")) == null || !(value instanceof JavaAnnotationListTypeValueModel) || (referenceList = (JavaAnnotationListTypeValueModel)value).getList() == null) continue;
                for (JavaAnnotationTypeValueModel ref : referenceList.getList()) {
                    if (ref instanceof JavaAnnotationTypeReferenceModel) {
                        JavaAnnotationTypeReferenceModel reference = (JavaAnnotationTypeReferenceModel)ref;
                        this.addNamedQuery((GraphService<JPANamedQueryModel>)namedQueryService, jpaEntity, reference);
                        continue;
                    }
                    LOG.warning("Unexpected Annotation in " + ref.toPrettyString());
                }
            }
        }
        if ((namedQueryList = Variables.instance((GraphRewrite)event).findVariable(NAMED_QUERY_LIST)) != null) {
            for (WindupVertexFrame annotationTypeReferenceBase : namedQueryList) {
                JavaAnnotationTypeReferenceModel annotationTypeReference = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceBase;
                if (!annotationTypeReference.getFile().equals(entityTypeReference.getFile())) continue;
                JavaAnnotationTypeReferenceModel reference = annotationTypeReference;
                this.addNamedQuery((GraphService<JPANamedQueryModel>)namedQueryService, jpaEntity, reference);
            }
        }
    }

    private void addNamedQuery(GraphService<JPANamedQueryModel> namedQueryService, JPAEntityModel jpaEntity, JavaAnnotationTypeReferenceModel reference) {
        String name = this.getAnnotationLiteralValue(reference, "name");
        String query = this.getAnnotationLiteralValue(reference, "query");
        LOG.info("Found query: " + name + " -> " + query);
        JPANamedQueryModel namedQuery = (JPANamedQueryModel)namedQueryService.create();
        namedQuery.setQueryName(name);
        namedQuery.setQuery(query);
        namedQuery.setJpaEntity(jpaEntity);
    }

    private JavaClassModel getJavaClass(JavaTypeReferenceModel javaTypeReference) {
        JavaClassModel result = null;
        AbstractJavaSourceModel javaSource = javaTypeReference.getFile();
        for (JavaClassModel javaClassModel : javaSource.getJavaClasses()) {
            if (javaClassModel.isPublic() == null || !javaClassModel.isPublic().booleanValue()) continue;
            result = javaClassModel;
            break;
        }
        if (result == null) {
            result = (JavaClassModel)javaSource.getJavaClasses().iterator().next();
        }
        return result;
    }

    public String toString() {
        return "DiscoverEJBAnnotatedClasses";
    }
}

