/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.jboss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.LinkService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.WebXmlModel;
import org.jboss.windup.rules.apps.javaee.model.association.VendorSpecificationExtensionModel;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=MigrationRulesPhase.class, id="Generate jboss-web.xml")
public class GenerateJBossWebDescriptorRuleProvider
extends AbstractRuleProvider {
    private static final Logger LOG = Logger.getLogger(GenerateJBossWebDescriptorRuleProvider.class.getSimpleName());
    public static final String JBOSS_WEB_TEMPLATE = "/reports/templates/jboss/jboss-web.ftl";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(WebXmlModel.class)).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : configurationModel.getInputPaths()) {
                    ProjectModel projectModel = inputPath.getProjectModel();
                    GenerateJBossWebDescriptorRuleProvider.this.transformWebXml(context, event.getGraphContext(), projectModel);
                }
            }

            public String toString() {
                return "Generate jboss-web.xml";
            }
        });
    }

    private void transformWebXml(EvaluationContext evaluationContext, GraphContext context, ProjectModel projectModel) {
        LinkService linkService = new LinkService(context);
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        VendorSpecificationExtensionService vendorSpecificService = new VendorSpecificationExtensionService(context);
        for (WebXmlModel webDescriptor : this.findAllWebXmlsInProject(context, projectModel)) {
            ApplicationReportModel applicationReportModel = applicationReportService.create();
            applicationReportModel.setReportPriority(300);
            applicationReportModel.setDisplayInApplicationReportIndex(Boolean.valueOf(false));
            applicationReportModel.setReportName("jboss-web.xml");
            applicationReportModel.setProjectModel(projectModel);
            applicationReportModel.setTemplatePath(JBOSS_WEB_TEMPLATE);
            applicationReportModel.setTemplateType(TemplateType.FREEMARKER);
            GraphService listService = new GraphService(context, WindupVertexListModel.class);
            WindupVertexListModel environmentReferences = (WindupVertexListModel)listService.create();
            for (EnvironmentReferenceModel ev : webDescriptor.getEnvironmentReferences()) {
                LOG.info("Reference: " + ev);
                environmentReferences.addItem((WindupVertexFrame)ev);
            }
            HashMap<String, WindupVertexListModel> additionalData = new HashMap<String, WindupVertexListModel>(4);
            additionalData.put("environmentReferences", environmentReferences);
            applicationReportModel.setRelatedResource(additionalData);
            ReportService reportService = new ReportService(context);
            reportService.setUniqueFilename((ReportModel)applicationReportModel, "jboss-web_" + projectModel.getName(), "xml");
            LOG.info("Generated jboss-web.xml for " + webDescriptor.getFilePath() + " at: " + applicationReportModel.getReportFilename());
            LinkModel link = (LinkModel)linkService.create();
            link.setDescription("JBoss Web XML Descriptor - Generated by Windup");
            link.setLink(applicationReportModel.getReportFilename());
            webDescriptor.addLinkToTransformedFile(link);
            LinkModel generatedDescriptor = (LinkModel)linkService.create();
            generatedDescriptor.setDescription("JBoss Web XML Descriptor - Generated by Windup");
            generatedDescriptor.setLink(applicationReportModel.getReportFilename());
            for (VendorSpecificationExtensionModel vendorSpecificExtension : vendorSpecificService.getVendorSpecificationExtensions((FileModel)webDescriptor)) {
                LOG.info("Vendor specific: " + vendorSpecificExtension.getFileName());
                vendorSpecificExtension.addLinkToTransformedFile(generatedDescriptor);
            }
        }
    }

    private Iterable<WebXmlModel> findAllWebXmlsInProject(GraphContext context, ProjectModel projectModel) {
        GraphService webDescriptors = new GraphService(context, WebXmlModel.class);
        ArrayList<WebXmlModel> resultModels = new ArrayList<WebXmlModel>();
        for (WebXmlModel webXmlModel : webDescriptors.findAll()) {
            if (!webXmlModel.getProjectModel().getRootProjectModel().equals(projectModel)) continue;
            resultModels.add(webXmlModel);
        }
        return resultModels;
    }
}

