/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules.websphere;

import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EnvironmentReferenceModel;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.JmsDestinationModel;
import org.jboss.windup.rules.apps.javaee.rules.DiscoverEjbConfigurationXmlRuleProvider;
import org.jboss.windup.rules.apps.javaee.service.EnvironmentReferenceService;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.JmsDestinationService;
import org.jboss.windup.rules.apps.javaee.service.VendorSpecificationExtensionService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=InitialAnalysisPhase.class, after={DiscoverEjbConfigurationXmlRuleProvider.class}, perform="Discover WebSphere EJB XML Files")
public class ResolveWebSphereEjbBindingXmlRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(ResolveWebSphereEjbBindingXmlRuleProvider.class.getSimpleName());

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("fileName", (Object)"ibm-ejb-jar-bnd.xmi").withProperty("rootTagName", (Object)"EJBJarBinding");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        EnvironmentReferenceService envRefService = new EnvironmentReferenceService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        JmsDestinationService jmsDestinationService = new JmsDestinationService(event.getGraphContext());
        GraphService ejbSessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        GraphService mdbService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        ClassificationService classificationService = new ClassificationService(event.getGraphContext());
        ClassificationModel classification = classificationService.attachClassification(event, context, (FileModel)payload, "WebSphere EJB Binding", "WebSphere Enterprise Java Bean Binding XML Descriptor");
        classification.setEffort(1);
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        technologyTagService.addTagToFileModel((FileModel)payload, "WebSphere EJB", TechnologyTagLevel.IMPORTANT);
        Document doc = xmlFileService.loadDocumentQuiet(event, context, payload);
        if (doc == null) {
            return;
        }
        VendorSpecificationExtensionService vendorSpecificationService = new VendorSpecificationExtensionService(event.getGraphContext());
        vendorSpecificationService.associateAsVendorExtension((FileModel)payload, "ejb-jar.xml");
        Set applications = ProjectTraversalCache.getApplicationsForProject((GraphContext)event.getGraphContext(), (ProjectModel)payload.getProjectModel());
        for (Element resourceRef : JOOX.$((Document)doc).find("ejbBindings").get()) {
            String href = JOOX.$((Element)resourceRef).child("enterpriseBean").attr("href");
            String resourceId = StringUtils.substringAfterLast((String)href, (String)"ejb-jar.xml#");
            String jndiLocation = JOOX.$((Element)resourceRef).attr("jndiName");
            String type = JOOX.$((Element)resourceRef).child("enterpriseBean").attr("type");
            LOG.info("Type: " + type);
            if (!StringUtils.isNotBlank((CharSequence)jndiLocation) || !StringUtils.isNotBlank((CharSequence)resourceId)) continue;
            JNDIResourceModel resource = jndiResourceService.createUnique(applications, jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceId);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("referenceId", resourceId)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
            for (EjbSessionBeanModel ejb : ejbSessionBeanService.findAllByProperty("ejbId", (Object)resourceId)) {
                ejb.setGlobalJndiReference(resource);
            }
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("resRefBindings").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "bindingResourceRef");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("ejbRefBindings").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "bindingEjbRef");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("messageDestinationRefBindings").get()) {
            this.processBinding(envRefService, jndiResourceService, applications, resourceRef, "bindingMessageDestinationRef");
        }
        for (Element resourceRef : JOOX.$((Document)doc).find("messageDestinationRefBindings").get()) {
            String jndiLocation = JOOX.$((Element)resourceRef).attr("jndiName");
            String mdbRef = JOOX.$((Element)resourceRef).siblings("enterpriseBean").attr("href");
            String mdbId = StringUtils.substringAfterLast((String)mdbRef, (String)"ejb-jar.xml#");
            if (!StringUtils.isNotBlank((CharSequence)mdbId)) continue;
            for (EjbMessageDrivenModel mdb : mdbService.findAllByProperty("ejbId", (Object)mdbId)) {
                String destination = jndiLocation;
                if (!StringUtils.isNotBlank((CharSequence)destination)) continue;
                JmsDestinationModel jndiRef = jmsDestinationService.createUnique(applications, destination);
                mdb.setDestination(jndiRef);
            }
        }
    }

    private void processBinding(EnvironmentReferenceService envRefService, JNDIResourceService jndiResourceService, Set<ProjectModel> applications, Element resourceRef, String tagName) {
        String href = JOOX.$((Element)resourceRef).child(tagName).attr("href");
        String resourceId = StringUtils.substringAfterLast((String)href, (String)"ejb-jar.xml#");
        String jndiLocation = JOOX.$((Element)resourceRef).attr("jndiName");
        if (StringUtils.isNotBlank((CharSequence)jndiLocation) && StringUtils.isNotBlank((CharSequence)resourceId)) {
            JNDIResourceModel resource = jndiResourceService.createUnique(applications, jndiLocation);
            LOG.info("JNDI Name: " + jndiLocation + " to Resource: " + resourceId);
            for (EnvironmentReferenceModel ref : envRefService.findAllByProperty("referenceId", resourceId)) {
                envRefService.associateEnvironmentToJndi(resource, ref);
            }
        }
    }
}

