/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.service;

import com.google.common.collect.Iterables;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Collections;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.javaee.model.EjbRemoteServiceModel;

public class EjbRemoteServiceModelService
extends GraphService<EjbRemoteServiceModel> {
    public EjbRemoteServiceModelService(GraphContext context) {
        super(context, EjbRemoteServiceModel.class);
    }

    public EjbRemoteServiceModel getOrCreate(Iterable<ProjectModel> applications, JavaClassModel remoteInterface, JavaClassModel implementationClass) {
        GremlinPipeline pipeline = new GremlinPipeline((Object)this.getGraphContext().getGraph());
        pipeline.V().has("w:winduptype", (Object)"EjbRemoteService");
        if (remoteInterface != null) {
            pipeline.as("remoteInterface").out(new String[]{"ejbRemoteInterface"}).retain(Collections.singleton(remoteInterface.asVertex())).back("remoteInterface");
        }
        if (implementationClass != null) {
            pipeline.as("implementationClass").out(new String[]{"ejbImplementationClass"}).retain(Collections.singleton(implementationClass.asVertex())).back("implementationClass");
        }
        if (pipeline.hasNext()) {
            EjbRemoteServiceModel result = (EjbRemoteServiceModel)this.frame((Vertex)pipeline.next());
            for (ProjectModel application : applications) {
                if (Iterables.contains(result.getApplications(), (Object)application)) continue;
                result.addApplication(application);
            }
            return result;
        }
        EjbRemoteServiceModel model = (EjbRemoteServiceModel)this.create();
        model.setApplications(applications);
        model.setInterface(remoteInterface);
        model.setImplementationClass(implementationClass);
        return model;
    }
}

