/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config;

import java.util.HashSet;
import java.util.Set;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.iteration.AbstractIterationFilter;
import org.jboss.windup.graph.model.FileReferenceModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedPatternResult;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class HasClassification
extends AbstractIterationFilter<WindupVertexFrame>
implements Parameterized {
    private RegexParameterizedPatternParser titlePattern;

    public boolean evaluate(GraphRewrite event, EvaluationContext context, WindupVertexFrame payload) {
        boolean result = false;
        ClassificationService service = new ClassificationService(event.getGraphContext());
        if (payload instanceof FileReferenceModel) {
            payload = ((FileReferenceModel)payload).getFile();
        }
        if (payload instanceof FileModel) {
            Iterable<ClassificationModel> classifications = service.getClassifications((FileModel)payload);
            if (this.titlePattern == null) {
                result = classifications.iterator().hasNext();
            } else {
                for (ClassificationModel c : classifications) {
                    ParameterizedPatternResult parseResult = this.titlePattern.parse(c.getClassification());
                    if (!parseResult.matches() || !parseResult.isValid((Rewrite)event, context)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public String getTitlePattern() {
        if (this.titlePattern != null) {
            return this.titlePattern.getPattern();
        }
        return null;
    }

    public void setTitlePattern(String titlePattern) {
        if (titlePattern != null) {
            this.titlePattern = new RegexParameterizedPatternParser(titlePattern);
        }
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>();
        if (this.titlePattern != null) {
            result.addAll(this.titlePattern.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        if (this.titlePattern != null) {
            this.titlePattern.setParameterStore(store);
        }
    }
}

