/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.renderer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.reporting.renderer.GraphRenderer;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.exception.WindupException;

public abstract class AbstractGraphRenderer
implements GraphRenderer {
    protected Path createOutputFolder(GraphContext graphContext, String name) {
        Path outputPath = this.getOutputPath(graphContext);
        Path outputFolder = outputPath.resolve(name);
        try {
            Files.createDirectories(outputFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new WindupException("Failed to write graph due to: " + e.getMessage(), (Throwable)e);
        }
        return outputFolder;
    }

    private Path getOutputPath(GraphContext graphContext) {
        return new ReportService(graphContext).getReportDirectory().resolve("renderedGraph");
    }
}

