/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.container.simple.lifecycle;

import java.lang.annotation.Annotation;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.container.simple.events.SimpleEventManagerImpl;
import org.jboss.forge.furnace.container.simple.impl.SimpleServiceRegistry;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.event.PostStartup;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.lifecycle.AddonLifecycleProvider;
import org.jboss.forge.furnace.lifecycle.ControlType;
import org.jboss.forge.furnace.spi.ServiceRegistry;

public class SimpleAddonLifecycleProvider
implements AddonLifecycleProvider {
    private Furnace furnace;
    private EventManager eventManager;
    private ServiceRegistry serviceRegistry;

    public void initialize(Furnace furnace, AddonRegistry registry, Addon self) throws Exception {
        this.furnace = furnace;
    }

    public void start(Addon addon) throws Exception {
        SimpleContainer.start((Addon)addon, (Furnace)this.furnace);
        this.serviceRegistry = new SimpleServiceRegistry(addon);
        this.eventManager = new SimpleEventManagerImpl(addon, this.serviceRegistry);
    }

    public void stop(Addon addon) throws Exception {
        SimpleContainer.stop((Addon)addon);
        if (this.serviceRegistry != null) {
            this.serviceRegistry.close();
        }
        this.serviceRegistry = null;
        this.eventManager = null;
    }

    public EventManager getEventManager(Addon addon) {
        return this.eventManager;
    }

    public ServiceRegistry getServiceRegistry(Addon addon) {
        return this.serviceRegistry;
    }

    public void postStartup(Addon addon) throws Exception {
        this.eventManager.fireEvent((Object)new PostStartup(addon), new Annotation[0]);
    }

    public void preShutdown(Addon addon) throws Exception {
        this.eventManager.fireEvent((Object)new PreShutdown(addon), new Annotation[0]);
    }

    public ControlType getControlType() {
        return ControlType.DEPENDENTS;
    }
}

