/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public class ResourcePathResolver {
    private static final Pattern WILDCARDS_PATTERN = Pattern.compile(".*(\\?|\\*)+.*");
    private static final Pattern WINDOWS_DRIVE_PATTERN = Pattern.compile("^[a-zA-Z]{1,1}:(/|\\\\).*");
    private int cursor;
    private final int length;
    private final ResourceFactory factory;
    private final Resource<?> res;
    private final String path;
    private final boolean isWindows = OperatingSystemUtils.isWindows();
    List<Resource<?>> results = new LinkedList();

    public ResourcePathResolver(ResourceFactory factory, Resource<?> res, String path) {
        this.factory = factory;
        this.res = res;
        this.path = path;
        this.length = path.length();
    }

    private ResourcePathResolver(ResourceFactory factory, Resource<?> res, String path, int cursor) {
        this.factory = factory;
        this.res = res;
        this.path = path;
        this.length = path.length();
        this.cursor = cursor;
    }

    public List<Resource<?>> resolve() {
        Resource<File> r = this.res;
        char slashChar = File.separatorChar;
        String slashString = File.separator;
        if (".".equals(this.path)) {
            return ResourcePathResolver.singleResult(r);
        }
        if (this.path.startsWith("~")) {
            File homeDir = OperatingSystemUtils.getUserHomeDir();
            if (this.path.length() == 1) {
                return ResourcePathResolver.singleResult(this.factory.create(DirectoryResource.class, homeDir));
            }
            ++this.cursor;
            r = this.factory.create(DirectoryResource.class, homeDir);
        } else if (this.isWindows && WINDOWS_DRIVE_PATTERN.matcher(this.path).matches()) {
            int idx = this.path.lastIndexOf(slashChar) + 1;
            r = this.factory.create(DirectoryResource.class, new File(this.path.substring(0, idx)).getAbsoluteFile());
            this.cursor = idx;
        } else if (this.path.matches(".*://.*")) {
            int idx = this.path.indexOf(" ");
            if (idx == -1) {
                idx = this.length;
            }
            try {
                r = this.factory.create(URLResource.class, new URL(this.path.substring(0, idx)));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            this.cursor = idx + 1;
        }
        block11: while (this.cursor < this.length) {
            Resource<?> child;
            switch (this.path.charAt(this.cursor++)) {
                case '/': 
                case '\\': {
                    if (this.cursor - 1 != 0) continue block11;
                    r = this.factory.create(new File(slashString).getAbsoluteFile());
                    continue block11;
                }
                case '.': {
                    switch (this.read()) {
                        case '.': {
                            ++this.cursor;
                            Resource<?> parent = r.getParent();
                            if (parent == null) continue block11;
                            r = parent;
                            continue block11;
                        }
                    }
                    if (this.cursor >= this.length || this.path.charAt(this.cursor) != slashChar) break;
                    ++this.cursor;
                    continue block11;
                }
            }
            boolean first = --this.cursor == 0;
            String tk = this.capture();
            if (WILDCARDS_PATTERN.matcher(tk).matches()) {
                Pattern p;
                boolean startDot = tk.startsWith(".");
                String regex = ResourcePathResolver.pathspecToRegEx(tk.startsWith(slashString) ? tk.substring(1) : tk);
                try {
                    p = Pattern.compile(regex);
                }
                catch (PatternSyntaxException pe) {
                    p = Pattern.compile(Pattern.quote(regex));
                }
                ArrayList res = new ArrayList();
                for (Resource<Object> child2 : r.listResources()) {
                    if (!p.matcher(child2.getName()).matches()) continue;
                    if (child2.getName().startsWith(".")) {
                        if (!startDot) continue;
                        res.add(child2);
                        continue;
                    }
                    res.add(child2);
                }
                if (this.cursor != this.length) {
                    for (Resource<Object> child2 : res) {
                        this.results.addAll(new ResourcePathResolver(this.factory, child2, this.path, this.cursor).resolve());
                    }
                } else {
                    this.results.addAll(res);
                }
                return this.results;
            }
            if (tk.startsWith(slashString)) {
                if (first) {
                    r = this.factory.create(new File(tk));
                    ++this.cursor;
                    continue;
                }
                tk = tk.substring(1);
            }
            if ((child = r.getChild(tk)) == null) {
                throw new RuntimeException("no such child: " + tk);
            }
            r = child;
        }
        return ResourcePathResolver.singleResult(r);
    }

    public List<Resource<?>> search() {
        return ResourcePathResolver.match(this.path.split(Pattern.quote(File.separator)), 0, this.res, new LinkedList());
    }

    private static List<Resource<?>> match(String[] matchLevels, int nestStart, Resource<?> res, List<Resource<?>> candidates) {
        String regex = ResourcePathResolver.pathspecToRegEx(matchLevels[nestStart]);
        Pattern matchPattern = Pattern.compile(regex);
        if (matchPattern.matcher(res.getName()).matches()) {
            if (nestStart < matchLevels.length && res instanceof DirectoryResource) {
                return ResourcePathResolver.match(matchLevels, nestStart + 1, res, candidates);
            }
            candidates.add(res);
            return candidates;
        }
        if (!(res instanceof DirectoryResource) || nestStart == matchLevels.length) {
            return candidates;
        }
        for (Resource<?> r : res.listResources()) {
            ResourcePathResolver.match(matchLevels, nestStart, r, candidates);
        }
        return candidates;
    }

    private static List<Resource<?>> singleResult(Resource<?> item) {
        return Collections.singletonList(item);
    }

    private char read() {
        if (this.cursor != this.length) {
            return this.path.charAt(this.cursor);
        }
        return '\u0000';
    }

    private String capture() {
        int start = this.cursor;
        if (this.path.charAt(this.cursor) == '/' || OperatingSystemUtils.isWindows() && this.path.charAt(this.cursor) == '\\') {
            ++this.cursor;
        }
        while (!(this.cursor >= this.length || OperatingSystemUtils.isWindows() && this.path.charAt(this.cursor) == '\\' || this.path.charAt(this.cursor) == '/')) {
            ++this.cursor;
        }
        return this.path.substring(start, this.cursor);
    }

    public static String pathspecToRegEx(String pathSpec) {
        StringBuilder sb = new StringBuilder("^");
        block5: for (int i = 0; i < pathSpec.length(); ++i) {
            char c = pathSpec.charAt(i);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block5;
                }
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.append("$").toString();
    }
}

