/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.evictor.Arbiter;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.evictor.TargetSelector;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThreadFactory;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.EnumSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Evictor
implements EnvConfigObserver {
    final EnvironmentImpl envImpl;
    private final TargetSelector selector;
    private final Arbiter arbiter;
    private final ThreadPoolExecutor evictionPool;
    private int terminateMillis;
    int dbCacheClearCount;
    private boolean runEvictor;
    private boolean allowBinDeltas;
    private static final int MAX_BATCHES_PER_RUN = 100;
    private final StatGroup stats;
    private final LongStat nEvictPasses;
    private final LongStat nNodesScanned;
    private final LongStat nNodesEvicted;
    private final LongStat nRootNodesEvicted;
    private final LongStat nBINsStripped;
    private final AtomicLongStat nLNFetch;
    private final AtomicLongStat nBINFetch;
    private final AtomicLongStat nUpperINFetch;
    private final AtomicLongStat nLNFetchMiss;
    private final AtomicLongStat nBINFetchMiss;
    private final AtomicLongStat nUpperINFetchMiss;
    private final AtomicLongStat nThreadUnavailable;
    private final AtomicLong nINSparseTarget;
    private final AtomicLong nINNoTarget;
    private final AtomicLong nINCompactKey;
    private final AtomicLongStat[] binEvictSources;
    private final AtomicLongStat[] inEvictSources;
    private final LongStat[] batchesPerSource;
    private final LongStat[] avgBatchPerSource;
    private final AtomicLong[] numBatchTargets;
    private final AtomicLong[] numBatches;
    private TestHook<Object> preEvictINHook;
    private TestHook<IN> evictProfile;
    private final ReentrancyGuard reentrancyGuard;
    private final AtomicBoolean shutdownRequested;
    private final Logger logger;

    Evictor(EnvironmentImpl envImpl) throws DatabaseException {
        this.envImpl = envImpl;
        this.stats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
        this.nEvictPasses = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_EVICT_PASSES);
        this.nNodesScanned = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_SCANNED);
        this.nNodesEvicted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_EVICTED);
        this.nRootNodesEvicted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED);
        this.nBINsStripped = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_BINS_STRIPPED);
        this.nLNFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.LN_FETCH);
        this.nBINFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_FETCH);
        this.nUpperINFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.UPPER_IN_FETCH);
        this.nLNFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.LN_FETCH_MISS);
        this.nBINFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_FETCH_MISS);
        this.nUpperINFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.UPPER_IN_FETCH_MISS);
        this.nThreadUnavailable = new AtomicLongStat(this.stats, EvictorStatDefinition.THREAD_UNAVAILABLE);
        this.nINSparseTarget = new AtomicLong(0L);
        this.nINNoTarget = new AtomicLong(0L);
        this.nINCompactKey = new AtomicLong(0L);
        EnumSet<EvictionSource> allSources = EnumSet.allOf(EvictionSource.class);
        int numSources = allSources.size();
        this.binEvictSources = new AtomicLongStat[numSources];
        this.inEvictSources = new AtomicLongStat[numSources];
        this.numBatches = new AtomicLong[numSources];
        this.numBatchTargets = new AtomicLong[numSources];
        this.batchesPerSource = new LongStat[numSources];
        this.avgBatchPerSource = new LongStat[numSources];
        for (EvictionSource source : allSources) {
            int index = source.ordinal();
            this.binEvictSources[index] = new AtomicLongStat(this.stats, source.getBINStatDef());
            this.inEvictSources[index] = new AtomicLongStat(this.stats, source.getUpperINStatDef());
            this.numBatches[index] = new AtomicLong();
            this.numBatchTargets[index] = new AtomicLong();
            this.batchesPerSource[index] = new LongStat(this.stats, source.getNumBatchesStatDef());
            this.avgBatchPerSource[index] = new LongStat(this.stats, source.getAvgBatchStatDef());
        }
        this.selector = this.makeSelector();
        this.arbiter = new Arbiter(envImpl);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.reentrancyGuard = new ReentrancyGuard(envImpl, this.logger);
        this.shutdownRequested = new AtomicBoolean(false);
        DbConfigManager configManager = envImpl.getConfigManager();
        int corePoolSize = configManager.getInt(EnvironmentParams.EVICTOR_CORE_THREADS);
        int maxPoolSize = configManager.getInt(EnvironmentParams.EVICTOR_MAX_THREADS);
        long keepAliveTime = configManager.getDuration(EnvironmentParams.EVICTOR_KEEP_ALIVE);
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        this.dbCacheClearCount = configManager.getInt(EnvironmentParams.ENV_DB_CACHE_CLEAR_COUNT);
        RejectEvictHandler rejectHandler = new RejectEvictHandler(this.nThreadUnavailable);
        this.evictionPool = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new StoppableThreadFactory(envImpl, "JEEvictor", this.logger), rejectHandler);
        this.runEvictor = configManager.getBoolean(EnvironmentParams.ENV_RUN_EVICTOR);
        this.allowBinDeltas = configManager.getBoolean(EnvironmentParams.EVICTOR_ALLOW_BIN_DELTAS);
        envImpl.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager configManager, EnvironmentMutableConfig ignore) throws DatabaseException {
        int corePoolSize = configManager.getInt(EnvironmentParams.EVICTOR_CORE_THREADS);
        int maxPoolSize = configManager.getInt(EnvironmentParams.EVICTOR_MAX_THREADS);
        long keepAliveTime = configManager.getDuration(EnvironmentParams.EVICTOR_KEEP_ALIVE);
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        this.dbCacheClearCount = configManager.getInt(EnvironmentParams.ENV_DB_CACHE_CLEAR_COUNT);
        this.evictionPool.setCorePoolSize(corePoolSize);
        this.evictionPool.setMaximumPoolSize(maxPoolSize);
        this.evictionPool.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
        this.runEvictor = configManager.getBoolean(EnvironmentParams.ENV_RUN_EVICTOR);
    }

    abstract TargetSelector makeSelector();

    public StatGroup loadStats(StatsConfig config) {
        StatGroup copy = this.stats.cloneGroup(config.getClear());
        new LongStat(copy, EvictorStatDefinition.CACHED_IN_SPARSE_TARGET, this.nINSparseTarget.get());
        new LongStat(copy, EvictorStatDefinition.CACHED_IN_NO_TARGET, this.nINNoTarget.get());
        new LongStat(copy, EvictorStatDefinition.CACHED_IN_COMPACT_KEY, this.nINCompactKey.get());
        copy.addAll(this.selector.loadStats(config));
        copy.addAll(this.arbiter.loadStats(config));
        EnumSet<EvictionSource> allSources = EnumSet.allOf(EvictionSource.class);
        for (EvictionSource source : allSources) {
            int index = source.ordinal();
            long nBatches = this.numBatches[index].getAndSet(0L);
            long avg = nBatches == 0L ? 0L : this.numBatchTargets[index].getAndSet(0L) / nBatches;
            this.batchesPerSource[index].set(nBatches);
            this.avgBatchPerSource[index].set(avg);
        }
        return copy;
    }

    public void doCriticalEviction(boolean backgroundIO) {
        if (this.arbiter.isOverBudget()) {
            this.alert();
            if (this.arbiter.needCriticalEviction()) {
                this.doEvict(EvictionSource.CRITICAL, backgroundIO);
            }
        }
    }

    public void doDaemonEviction(boolean backgroundIO) {
        if (this.arbiter.isOverBudget()) {
            this.alert();
            this.doEvict(EvictionSource.DAEMON, backgroundIO);
        }
    }

    public void doManualEvict() throws DatabaseException {
        this.doEvict(EvictionSource.MANUAL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvictOneIN(IN target, EvictionSource source) {
        if (!this.reentrancyGuard.enter()) {
            return;
        }
        try {
            this.evictIN(target, false, source);
        }
        finally {
            this.reentrancyGuard.leave();
        }
    }

    public void alert() {
        if (!this.runEvictor) {
            return;
        }
        this.evictionPool.execute(new BackgroundEvictTask(this, true));
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.evictionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doEvict(EvictionSource source, boolean backgroundIO) throws DatabaseException {
        if (!this.reentrancyGuard.enter()) {
            return;
        }
        try {
            long maxEvictBytes;
            int nBatches;
            boolean progress = true;
            long bytesEvicted = 0L;
            this.numBatches[source.ordinal()].incrementAndGet();
            for (nBatches = 0; progress && nBatches < 100 && !this.shutdownRequested.get() && (maxEvictBytes = this.arbiter.getEvictionPledge()) != 0L; ++nBatches) {
                bytesEvicted = this.evictBatch(source, backgroundIO, maxEvictBytes);
                if (bytesEvicted != 0L) continue;
                progress = false;
            }
            if (source == EvictionSource.EVICTORTHREAD && this.logger.isLoggable(Level.FINEST)) {
                LoggerUtils.finest(this.logger, this.envImpl, "Thread evicted " + bytesEvicted + " bytes in " + nBatches + " batches");
            }
        }
        finally {
            this.reentrancyGuard.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long evictBatch(EvictionSource source, boolean backgroundIO, long maxEvictBytes) throws DatabaseException {
        int numNodesScannedThisBatch;
        this.nEvictPasses.increment();
        assert (TestHookExecute.doHookSetupIfSet(this.evictProfile));
        TargetSelector.SetupInfo setupInfo = this.selector.startBatch(true);
        long evictBytes = setupInfo.specialEvictionBytes;
        int maxINsPerBatch = setupInfo.maxINsPerBatch;
        if (maxINsPerBatch == 0) {
            return evictBytes;
        }
        DbCache dbCache = this.createDbCache();
        try {
            TargetSelector.ScanInfo scanInfo;
            for (numNodesScannedThisBatch = 0; evictBytes < maxEvictBytes && numNodesScannedThisBatch <= maxINsPerBatch && this.arbiter.stillNeedsEviction(); numNodesScannedThisBatch += scanInfo.numNodesScanned) {
                scanInfo = this.selector.selectIN(maxINsPerBatch);
                IN target = scanInfo.target;
                if (target == null) {
                    break;
                }
                this.numBatchTargets[source.ordinal()].incrementAndGet();
                assert (TestHookExecute.doHookIfSet(this.evictProfile, target));
                DatabaseImpl targetDb = target.getDatabase();
                DatabaseImpl refreshedDb = dbCache.getDb(targetDb.getDbEnvironment(), targetDb.getId());
                if (refreshedDb == null || refreshedDb != targetDb || refreshedDb.isDeleted()) continue;
                if (target.isDbRoot()) {
                    evictBytes += this.evictRoot(target, backgroundIO);
                    continue;
                }
                evictBytes += this.evictIN(target, backgroundIO, source);
            }
        }
        finally {
            this.nNodesScanned.add(numNodesScannedThisBatch);
            dbCache.releaseDbs();
        }
        return evictBytes;
    }

    private long evictRoot(final IN target, final boolean backgroundIO) throws DatabaseException {
        DatabaseImpl db = target.getDatabase();
        final EnvironmentImpl useEnvImpl = db.getDbEnvironment();
        final INList inList = useEnvImpl.getInMemoryINs();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class RootEvictor
        implements WithRootLatched {
            boolean flushed = false;
            long evictBytes = 0L;

            RootEvictor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IN doWork(ChildReference root) throws DatabaseException {
                IN rootIN = (IN)root.getTarget();
                if (rootIN == null) {
                    return null;
                }
                rootIN.latch(CacheMode.UNCHANGED);
                try {
                    boolean isDirty = rootIN.getDirty();
                    if (rootIN == target && rootIN.getInListResident() && rootIN.isDbRoot() && rootIN.isEvictable() && (!useEnvImpl.isReadOnly() || !isDirty)) {
                        boolean logProvisional = Evictor.this.coordinateWithCheckpoint(rootIN, null);
                        if (isDirty) {
                            long newLsn = rootIN.log(useEnvImpl.getLogManager(), false, false, logProvisional, backgroundIO, null);
                            root.setLsn(newLsn);
                            this.flushed = true;
                        }
                        inList.remove(rootIN);
                        this.evictBytes = rootIN.getBudgetedMemorySize();
                        root.clearTarget();
                        Evictor.this.nRootNodesEvicted.increment();
                    }
                }
                finally {
                    rootIN.releaseLatch();
                }
                return null;
            }
        }
        RootEvictor evictor = new RootEvictor();
        db.getTree().withRootLatchedExclusive(evictor);
        if (evictor.flushed) {
            useEnvImpl.getDbTree().modifyDbRoot(db);
        }
        return evictor.evictBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evictIN(IN target, boolean backgroundIO, EvictionSource source) throws DatabaseException {
        boolean inline;
        DatabaseImpl db = target.getDatabase();
        EnvironmentImpl useEnvImpl = db.getDbEnvironment();
        long evictedBytes = 0L;
        boolean bl = inline = source == EvictionSource.CACHEMODE;
        if (inline) {
            target.latch(CacheMode.UNCHANGED);
        } else if (!target.latchNoWait(CacheMode.UNCHANGED)) {
            return evictedBytes;
        }
        boolean targetIsLatched = true;
        boolean success = false;
        try {
            if (!target.getInListResident()) {
                long l = evictedBytes;
                return l;
            }
            if (target instanceof BIN && (evictedBytes = ((BIN)target).evictLNs()) > 0L) {
                this.nBINsStripped.increment();
            }
            if (!inline && evictedBytes != 0L) {
                success = true;
                long l = evictedBytes;
                return l;
            }
            if (!target.isEvictable()) {
                success = true;
                long l = evictedBytes;
                return l;
            }
            Tree tree = db.getTree();
            assert (TestHookExecute.doHookIfSet(this.preEvictINHook));
            targetIsLatched = false;
            SearchResult result = tree.getParentINForChildIN(target, true, CacheMode.UNCHANGED);
            if (result.exactParentFound) {
                evictedBytes = this.evictIN(target, result.parent, result.index, backgroundIO, source);
            }
            success = true;
            long l = evictedBytes;
            return l;
        }
        finally {
            if (targetIsLatched) {
                target.releaseLatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evictIN(IN child, IN parent, int index, boolean backgroundIO, EvictionSource source) throws DatabaseException {
        long evictBytes = 0L;
        try {
            boolean inline;
            assert (parent.isLatchOwnerForWrite());
            long oldGenerationCount = child.getGeneration();
            IN renewedChild = (IN)parent.getTarget(index);
            if (renewedChild == null) {
                long l = evictBytes;
                return l;
            }
            boolean bl = inline = source == EvictionSource.CACHEMODE;
            if (!inline && renewedChild.getGeneration() > oldGenerationCount) {
                long l = evictBytes;
                return l;
            }
            if (inline) {
                renewedChild.latch(CacheMode.UNCHANGED);
            } else if (!renewedChild.latchNoWait(CacheMode.UNCHANGED)) {
                long l = evictBytes;
                return l;
            }
            try {
                if (!renewedChild.isEvictable()) {
                    long l = evictBytes;
                    return l;
                }
                DatabaseImpl db = renewedChild.getDatabase();
                EnvironmentImpl useEnvImpl = db.getDbEnvironment();
                long renewedChildLsn = -1L;
                boolean newChildLsn = false;
                if (renewedChild.getDirty()) {
                    if (!useEnvImpl.isReadOnly()) {
                        boolean logProvisional = this.coordinateWithCheckpoint(renewedChild, parent);
                        renewedChildLsn = renewedChild.log(useEnvImpl.getLogManager(), this.allowBinDeltas, true, logProvisional, backgroundIO, parent);
                        newChildLsn = true;
                    }
                } else {
                    renewedChildLsn = parent.getLsn(index);
                }
                if (renewedChildLsn != -1L) {
                    useEnvImpl.getInMemoryINs().remove(renewedChild);
                    evictBytes = renewedChild.getBudgetedMemorySize();
                    if (newChildLsn) {
                        parent.updateNode(index, null, renewedChildLsn, null);
                    } else {
                        parent.updateNode(index, null, null);
                    }
                    this.nNodesEvicted.increment();
                    renewedChild.incEvictStats(source);
                }
            }
            finally {
                renewedChild.releaseLatch();
            }
        }
        finally {
            parent.releaseLatch();
        }
        return evictBytes;
    }

    public void incBINEvictStats(EvictionSource source) {
        this.binEvictSources[source.ordinal()].increment();
    }

    public void incINEvictStats(EvictionSource source) {
        this.inEvictSources[source.ordinal()].increment();
    }

    public void incLNFetchStats(boolean isMiss) {
        this.nLNFetch.increment();
        if (isMiss) {
            this.nLNFetchMiss.increment();
        }
    }

    public void incBINFetchStats(boolean isMiss) {
        this.nBINFetch.increment();
        if (isMiss) {
            this.nBINFetchMiss.increment();
        }
    }

    public void incINFetchStats(boolean isMiss) {
        this.nUpperINFetch.increment();
        if (isMiss) {
            this.nUpperINFetchMiss.increment();
        }
    }

    public AtomicLong getNINSparseTarget() {
        return this.nINSparseTarget;
    }

    public AtomicLong getNINNoTarget() {
        return this.nINNoTarget;
    }

    public AtomicLong getNINCompactKey() {
        return this.nINCompactKey;
    }

    private boolean coordinateWithCheckpoint(IN target, IN parent) {
        EnvironmentImpl useEnvImpl = target.getDatabase().getDbEnvironment();
        Checkpointer ckpter = useEnvImpl.getCheckpointer();
        if (ckpter == null) {
            return false;
        }
        return ckpter.coordinateEvictionWithCheckpoint(target, parent);
    }

    public void addEnvironment(EnvironmentImpl additionalEnvImpl) {
        this.selector.addEnvironment(additionalEnvImpl);
    }

    public void removeEnvironment(EnvironmentImpl targetEnvImpl) {
        this.selector.removeEnvironment(targetEnvImpl);
    }

    public void setPreEvictINHook(TestHook<Object> hook) {
        this.preEvictINHook = hook;
    }

    public void setEvictProfileHook(TestHook<IN> hook) {
        this.evictProfile = hook;
    }

    public void noteINListChange(int nINs) {
        this.selector.noteINListChange(nINs);
    }

    public boolean checkEnv(EnvironmentImpl env) {
        return this.selector.checkEnv(env);
    }

    public StatGroup getStatsGroup() {
        return this.stats;
    }

    public void setRunnableHook(TestHook<Boolean> hook) {
        this.arbiter.setRunnableHook(hook);
    }

    public boolean isCacheFull() {
        return this.arbiter.isCacheFull();
    }

    public boolean wasCacheEverFull() {
        return this.arbiter.wasCacheEverFull();
    }

    TargetSelector getSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownRequested.set(true);
        this.evictionPool.shutdown();
        boolean shutdownFinished = false;
        try {
            shutdownFinished = this.evictionPool.awaitTermination(this.terminateMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (!shutdownFinished) {
                this.evictionPool.shutdownNow();
            }
        }
    }

    public void requestShutdownPool() {
        this.shutdownRequested.set(true);
        this.evictionPool.shutdown();
    }

    abstract DbCache createDbCache();

    static interface DbCache {
        public DatabaseImpl getDb(EnvironmentImpl var1, DatabaseId var2);

        public void releaseDbs();
    }

    static class RejectEvictHandler
    implements RejectedExecutionHandler {
        private final AtomicLongStat threadUnavailableStat;

        RejectEvictHandler(AtomicLongStat threadUnavailableStat) {
            this.threadUnavailableStat = threadUnavailableStat;
        }

        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            this.threadUnavailableStat.increment();
        }
    }

    static class BackgroundEvictTask
    implements Runnable {
        private final Evictor evictor;
        private final boolean backgroundIO;

        BackgroundEvictTask(Evictor evictor, boolean backgroundIO) {
            this.evictor = evictor;
            this.backgroundIO = backgroundIO;
        }

        public void run() {
            this.evictor.doEvict(EvictionSource.EVICTORTHREAD, this.backgroundIO);
        }
    }

    private static class ReentrancyGuard {
        private final ConcurrentHashMap<Thread, Thread> activeThreads;
        private final EnvironmentImpl envImpl;
        private final Logger logger;

        ReentrancyGuard(EnvironmentImpl envImpl, Logger logger) {
            this.envImpl = envImpl;
            this.logger = logger;
            this.activeThreads = new ConcurrentHashMap();
        }

        boolean enter() {
            Thread thisThread = Thread.currentThread();
            if (this.activeThreads.containsKey(thisThread)) {
                LoggerUtils.severe(this.logger, this.envImpl, "reentrant call to eviction from " + LoggerUtils.getStackTrace());
                assert (false) : "reentrant call to eviction from " + LoggerUtils.getStackTrace();
                return false;
            }
            this.activeThreads.put(thisThread, thisThread);
            return true;
        }

        void leave() {
            assert (this.activeThreads.contains(Thread.currentThread()));
            this.activeThreads.remove(Thread.currentThread());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EvictionSource {
        EVICTORTHREAD,
        MANUAL,
        CRITICAL,
        CACHEMODE,
        DAEMON;


        public StatDefinition getBINStatDef() {
            return new StatDefinition("nBINsEvicted" + this.toString(), "Number of BINs evicted from the cache, using the specified eviction source. As a subset of nNodesEvicted, it is an indicator of what eviction is targeting and the activity that is instigating eviction");
        }

        public StatDefinition getUpperINStatDef() {
            return new StatDefinition("nUpperINsEvicted" + this.toString(), "Number of upper INs evicted from the cache, using the specified eviction source. As a subset of nNodesEvicted, it is an indicator of what eviction is targeting and the activity that is instigating eviction");
        }

        public StatDefinition getNumBatchesStatDef() {
            return new StatDefinition("nBatches" + this.toString(), "Number of attempts to evict, by type of evictor. Along with average batch size, it serves as an indicator of what part of the system is doing eviction work.");
        }

        public StatDefinition getAvgBatchStatDef() {
            return new StatDefinition("avgBatch" + this.toString(), "Average units of work done by one eviction pass. Along with the number of  batch size, it serves as an indicator of what part of the system is doing eviction work.");
        }
    }
}

