/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.ip;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.ReportGenerationPhase;
import org.jboss.windup.config.projecttraversal.ProjectTraversalCache;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.WindupConfigurationModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.graph.service.WindupConfigurationService;
import org.jboss.windup.reporting.model.ApplicationReportModel;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.model.TemplateType;
import org.jboss.windup.reporting.model.WindupVertexListModel;
import org.jboss.windup.reporting.service.ApplicationReportService;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.rules.apps.java.ip.HardcodedIPLocationModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

@RuleMetadata(phase=ReportGenerationPhase.class)
public class CreateHardcodedIPAddressReportRuleProvider
extends AbstractRuleProvider {
    private static final String TITLE = "Hard-coded IP Addresses";
    public static final String TEMPLATE_REPORT = "/reports/templates/hardcoded_ip_addresses.ftl";
    public static final String REPORT_DESCRIPTION = "The Hard-coded IP report provides a list of all hard-coded IP addresses that were found in the application. These often require review during migration.";

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(HardcodedIPLocationModel.class)).perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                WindupConfigurationModel configurationModel = WindupConfigurationService.getConfigurationModel((GraphContext)event.getGraphContext());
                for (FileModel inputPath : configurationModel.getInputPaths()) {
                    ProjectModel projectModel = inputPath.getProjectModel();
                    CreateHardcodedIPAddressReportRuleProvider.this.createIPReport(event.getGraphContext(), projectModel);
                }
            }
        });
    }

    private void createIPReport(GraphContext context, ProjectModel rootProjectModel) {
        GraphService ipLocationModelService = new GraphService(context, HardcodedIPLocationModel.class);
        ArrayList<HardcodedIPLocationModel> hardcodedIPArrayList = new ArrayList<HardcodedIPLocationModel>();
        for (HardcodedIPLocationModel location : ipLocationModelService.findAll()) {
            Set applicationsForFile = ProjectTraversalCache.getApplicationsForProject((GraphContext)context, (ProjectModel)location.getFile().getProjectModel());
            if (!applicationsForFile.contains(rootProjectModel)) continue;
            hardcodedIPArrayList.add(location);
        }
        if (hardcodedIPArrayList.isEmpty()) {
            return;
        }
        ApplicationReportService applicationReportService = new ApplicationReportService(context);
        ApplicationReportModel applicationReport = applicationReportService.create();
        applicationReport.setReportPriority(600);
        applicationReport.setReportName(TITLE);
        applicationReport.setDescription(REPORT_DESCRIPTION);
        applicationReport.setTemplatePath(TEMPLATE_REPORT);
        applicationReport.setDisplayInApplicationReportIndex(Boolean.valueOf(true));
        applicationReport.setReportIconClass("glyphicon glyphicon-map-marker");
        applicationReport.setTemplateType(TemplateType.FREEMARKER);
        applicationReport.setProjectModel(rootProjectModel);
        HashMap<String, WindupVertexListModel> relatedData = new HashMap<String, WindupVertexListModel>(1);
        WindupVertexListModel hardcodedIPListModel = (WindupVertexListModel)new GraphService(context, WindupVertexListModel.class).create();
        hardcodedIPListModel.addAll(hardcodedIPArrayList);
        relatedData.put("hardcodedIPLocations", hardcodedIPListModel);
        applicationReport.setRelatedResource(relatedData);
        ReportService reportService = new ReportService(context);
        reportService.setUniqueFilename((ReportModel)applicationReport, "hardcoded_ips" + rootProjectModel.getName(), "html");
    }
}

