/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.ip;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.loader.RuleLoaderContext;
import org.jboss.windup.config.metadata.RuleMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.FileLocationModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.ip.HardcodedIPLocationModel;
import org.jboss.windup.rules.apps.java.model.PropertiesModel;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.files.condition.FileContent;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@RuleMetadata(phase=MigrationRulesPhase.class)
public class DiscoverHardcodedIPAddressRuleProvider
extends AbstractRuleProvider {
    private static final String IP_PATTERN = "(?<![\\w.])\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}(?![\\w.])";
    private static final Logger LOG = Logger.getLogger(DiscoverHardcodedIPAddressRuleProvider.class.getSimpleName());

    public Configuration getConfiguration(RuleLoaderContext ruleLoaderContext) {
        return ConfigurationBuilder.begin().addRule().when((Condition)FileContent.matches((String)"{ip}").inFileNamed("{*}.{type}")).perform((Operation)new AbstractIterationOperation<FileLocationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, FileLocationModel payload) {
                if (InetAddressValidator.getInstance().isValid(payload.getSourceSnippit())) {
                    if (DiscoverHardcodedIPAddressRuleProvider.this.ignoreLine(event.getGraphContext(), payload)) {
                        return;
                    }
                    if (payload.getFile() instanceof SourceFileModel) {
                        ((SourceFileModel)payload.getFile()).setGenerateSourceReport(true);
                    }
                    HardcodedIPLocationModel location = (HardcodedIPLocationModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, HardcodedIPLocationModel.class);
                    location.setRuleID(((Rule)context.get(Rule.class)).getId());
                    location.setTitle("Hard-coded IP Address Detected");
                    StringBuilder hintBody = new StringBuilder("**Hard-coded IP: ");
                    hintBody.append(payload.getSourceSnippit());
                    hintBody.append("**");
                    hintBody.append("\n\n");
                    hintBody.append("When migrating environments, hard-coded IP addresses may need to be modified or eliminated.");
                    location.setHint(hintBody.toString());
                    location.setEffort(0);
                }
            }
        }).where("ip").matches(IP_PATTERN).where("type").matches("java|properties|xml").withId(((Object)((Object)this)).getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ignoreLine(GraphContext context, FileLocationModel model) {
        isPropertiesFile = model.getFile() instanceof PropertiesModel;
        lineNumber = model.getLineNumber();
        li = null;
        try {
            li = FileUtils.lineIterator((File)model.getFile().asFile());
            i = 0;
lbl7:
            // 3 sources

            while (li.hasNext()) {
                if (++i != lineNumber) ** GOTO lbl-1000
                line = StringUtils.trim((String)li.next());
                if (!isPropertiesFile || !StringUtils.startsWith((CharSequence)line, (CharSequence)"#")) ** GOTO lbl-1000
                var8_9 = true;
                ** GOTO lbl21
            }
            ** GOTO lbl41
        }
        catch (IOException | RuntimeException e) {
            try {
                DiscoverHardcodedIPAddressRuleProvider.LOG.log(Level.WARNING, "Exception reading properties from file: " + model.getFile().getFilePath(), e);
            }
            catch (Throwable var9_13) {
                LineIterator.closeQuietly(li);
                throw var9_13;
            }
lbl21:
            // 1 sources

            LineIterator.closeQuietly((LineIterator)li);
            return var8_9;
lbl-1000:
            // 1 sources

            {
                if (!StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"version") && !StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)"revision")) ** GOTO lbl-1000
                var8_10 = true;
            }
            LineIterator.closeQuietly((LineIterator)li);
            return var8_10;
lbl-1000:
            // 1 sources

            {
                if (!this.isMavenVersionTag(context, model)) ** GOTO lbl-1000
                var8_11 = true;
            }
            LineIterator.closeQuietly((LineIterator)li);
            return var8_11;
lbl-1000:
            // 1 sources

            {
                var8_12 = false;
            }
            LineIterator.closeQuietly((LineIterator)li);
            return var8_12;
lbl-1000:
            // 1 sources

            {
                block9: {
                    if (i >= lineNumber) break block9;
                    li.next();
                    ** GOTO lbl7
                }
                if (i <= lineNumber) ** GOTO lbl7
                DiscoverHardcodedIPAddressRuleProvider.LOG.warning("Did not find line: " + lineNumber + " in file: " + model.getFile().getFileName());
            }
lbl41:
            // 2 sources

            LineIterator.closeQuietly((LineIterator)li);
            return false;
            LineIterator.closeQuietly((LineIterator)li);
            return false;
        }
    }

    private boolean isMavenFile(GraphContext context, FileLocationModel model) {
        if (!(model.getFile() instanceof XmlFileModel)) {
            return false;
        }
        ClassificationService cs = new ClassificationService(context);
        Iterator iterator = cs.getClassificationByName(model.getFile(), "Maven POM").iterator();
        if (iterator.hasNext()) {
            ClassificationModel cm = (ClassificationModel)iterator.next();
            return true;
        }
        return false;
    }

    private boolean isMavenVersionTag(GraphContext context, FileLocationModel model) {
        if (this.isMavenFile(context, model)) {
            Document doc = ((XmlFileModel)model.getFile()).asDocument();
            for (Element elm : JOOX.$((Document)doc).find("version")) {
                String text = StringUtils.trim((String)JOOX.$((Element)elm).text());
                if (!StringUtils.equals((CharSequence)text, (CharSequence)model.getSourceSnippit())) continue;
                return true;
            }
        }
        return false;
    }
}

