/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.query;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.util.ExecutionStatistics;

public class FindFilesNotClassifiedOrHintedGremlinCriterion {
    public Iterable<Vertex> query(final GraphContext context, Iterable<Vertex> initialVertices) {
        ExecutionStatistics.get().begin("FindFilesNotClassifiedOrHintedGremlinCriterion.total");
        List initialVerticesList = Lists.toList(initialVertices);
        GremlinPipeline pipeline = new GremlinPipeline(initialVertices);
        final HashSet allClassifiedOrHintedVertices = new HashSet();
        ExecutionStatistics.get().begin("FindFilesNotClassifiedOrHintedGremlinCriterion.hintPipeline");
        GremlinPipeline hintPipeline = new GremlinPipeline((Object)context.getQuery().type(InlineHintModel.class).vertices());
        hintPipeline.as("fileLocation1").out(new String[]{"file"}).retain((Collection)initialVerticesList);
        hintPipeline.fill(allClassifiedOrHintedVertices);
        ExecutionStatistics.get().end("FindFilesNotClassifiedOrHintedGremlinCriterion.hintPipeline");
        ExecutionStatistics.get().begin("FindFilesNotClassifiedOrHintedGremlinCriterion.classificationPipeline");
        GremlinPipeline classificationPipeline = new GremlinPipeline((Object)context.getQuery().type(ClassificationModel.class).vertices());
        classificationPipeline.as("fileModel2").out(new String[]{"ClassificationModel:classificationModelToFileModel"}).retain((Collection)initialVerticesList);
        classificationPipeline.fill(allClassifiedOrHintedVertices);
        ExecutionStatistics.get().end("FindFilesNotClassifiedOrHintedGremlinCriterion.classificationPipeline");
        pipeline.filter((PipeFunction)new PipeFunction<Vertex, Boolean>(){

            public Boolean compute(Vertex v) {
                JavaSourceFileModel source;
                Iterator decompiled;
                FileModel f = (FileModel)context.getFramed().frame(v, FileModel.class);
                if (allClassifiedOrHintedVertices.contains(v)) {
                    return false;
                }
                if (f.isWindupGenerated().booleanValue()) {
                    return false;
                }
                if (f instanceof JavaClassFileModel && (decompiled = v.getVertices(Direction.OUT, new String[]{"decompiledFile"}).iterator()).hasNext() && allClassifiedOrHintedVertices.contains((source = (JavaSourceFileModel)context.getFramed().frame((Vertex)decompiled.next(), JavaSourceFileModel.class)).asVertex())) {
                    return false;
                }
                return true;
            }
        });
        ExecutionStatistics.get().end("FindFilesNotClassifiedOrHintedGremlinCriterion.total");
        return pipeline;
    }
}

