/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.ast.trie;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.windup.rules.apps.java.scan.ast.trie.TrieStructureTypeRelation;

public class TriePrefixStructure<SAVE_TYPE, SEARCH_TYPE> {
    private static TriePrefixStructure defaultInstance;
    private final Set<SAVE_TYPE> currentLevelSet = new LinkedHashSet<SAVE_TYPE>();
    private final Map<Character, TriePrefixStructure<SAVE_TYPE, SEARCH_TYPE>> typeInterestMap = new HashMap<Character, TriePrefixStructure<SAVE_TYPE, SEARCH_TYPE>>(26);
    private final TrieStructureTypeRelation relation;

    public TriePrefixStructure(TrieStructureTypeRelation<SAVE_TYPE, SEARCH_TYPE> relation) {
        this.relation = relation;
    }

    public void clear() {
        this.currentLevelSet.clear();
        this.typeInterestMap.clear();
    }

    public boolean matches(SEARCH_TYPE search) {
        String prefix = this.relation.getStringToSearchFromSearchType(search);
        return this.matches(prefix, search, 0);
    }

    private boolean matches(String prefix, SEARCH_TYPE search, int currentIndex) {
        if (!this.currentLevelSet.isEmpty()) {
            for (SAVE_TYPE interest : this.currentLevelSet) {
                if (!this.relation.checkIfMatchFound(interest, search)) continue;
                return true;
            }
        }
        if (currentIndex >= prefix.length()) {
            return false;
        }
        Character currentCharacter = Character.valueOf(prefix.charAt(currentIndex));
        TriePrefixStructure<SAVE_TYPE, SEARCH_TYPE> resolver = this.typeInterestMap.get(currentCharacter);
        if (resolver == null) {
            return false;
        }
        return super.matches(prefix, search, currentIndex + 1);
    }

    public void addInterest(SAVE_TYPE save) {
        String prefix = this.relation.getStringPrefixToSaveSaveType(save);
        this.addInterest(prefix, save, 0);
    }

    private void addInterest(String referencePrefix, SAVE_TYPE save, int currentIndex) {
        if (currentIndex >= referencePrefix.length()) {
            this.currentLevelSet.add(save);
            return;
        }
        Character currentCharacter = Character.valueOf(referencePrefix.charAt(currentIndex));
        TriePrefixStructure<SAVE_TYPE, SEARCH_TYPE> resolver = this.typeInterestMap.get(currentCharacter);
        if (resolver == null) {
            resolver = new TriePrefixStructure<SAVE_TYPE, SEARCH_TYPE>(this.relation);
            this.typeInterestMap.put(currentCharacter, resolver);
        }
        super.addInterest(referencePrefix, save, currentIndex + 1);
    }
}

